/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.partition.ProducerFailedException;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.shaded.guava18.com.google.common.collect.Sets;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionRequestQueue
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionRequestQueue.class);
    private final ArrayDeque<NetworkSequenceViewReader> availableReaders = new ArrayDeque();
    private final ConcurrentMap<InputChannelID, NetworkSequenceViewReader> allReaders = new ConcurrentHashMap<InputChannelID, NetworkSequenceViewReader>();
    private final Set<InputChannelID> released = Sets.newHashSet();
    private boolean fatalError;
    private ChannelHandlerContext ctx;

    PartitionRequestQueue() {
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.ctx == null) {
            this.ctx = ctx;
        }
        super.channelRegistered(ctx);
    }

    void notifyReaderNonEmpty(final NetworkSequenceViewReader reader) {
        this.ctx.executor().execute(new Runnable(){

            @Override
            public void run() {
                PartitionRequestQueue.this.ctx.pipeline().fireUserEventTriggered((Object)reader);
            }
        });
    }

    private void enqueueAvailableReader(NetworkSequenceViewReader reader) throws Exception {
        if (reader.isRegisteredAsAvailable() || !reader.isAvailable()) {
            return;
        }
        boolean triggerWrite = this.availableReaders.isEmpty();
        this.registerAvailableReader(reader);
        if (triggerWrite) {
            this.writeAndFlushNextMessageIfPossible(this.ctx.channel());
        }
    }

    @VisibleForTesting
    ArrayDeque<NetworkSequenceViewReader> getAvailableReaders() {
        return this.availableReaders;
    }

    @VisibleForTesting
    Collection<NetworkSequenceViewReader> getAllReaders() {
        return this.allReaders.values();
    }

    public void notifyReaderCreated(NetworkSequenceViewReader reader) {
        this.allReaders.put(reader.getReceiverId(), reader);
    }

    public void cancel(InputChannelID receiverId) {
        this.ctx.pipeline().fireUserEventTriggered((Object)receiverId);
    }

    public void close() throws IOException {
        if (this.ctx != null) {
            this.ctx.channel().close();
        }
        for (NetworkSequenceViewReader reader : this.allReaders.values()) {
            reader.notifySubpartitionConsumed();
        }
        this.releaseAllResources();
    }

    void addCredit(InputChannelID receiverId, int credit) throws Exception {
        if (this.fatalError) {
            return;
        }
        NetworkSequenceViewReader reader = (NetworkSequenceViewReader)this.allReaders.get((Object)receiverId);
        if (reader == null) {
            throw new IllegalStateException("No reader for receiverId = " + (Object)((Object)receiverId) + " exists.");
        }
        reader.addCredit(credit);
        this.enqueueAvailableReader(reader);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof NetworkSequenceViewReader) {
            this.enqueueAvailableReader((NetworkSequenceViewReader)msg);
        } else if (msg.getClass() == InputChannelID.class) {
            InputChannelID toCancel = (InputChannelID)((Object)msg);
            if (this.released.contains((Object)toCancel)) {
                return;
            }
            this.markAsReleased(toCancel);
            NetworkSequenceViewReader toReleasedReader = (NetworkSequenceViewReader)this.allReaders.remove((Object)toCancel);
            if (toReleasedReader != null) {
                toReleasedReader.releaseAllResources();
            } else {
                LOG.warn("The view for this receiver {} has not been created or has been canceled before!", (Object)toCancel);
            }
            int size = this.availableReaders.size();
            for (int i = 0; i < size; ++i) {
                NetworkSequenceViewReader reader = this.pollAvailableReader();
                if (reader.getReceiverId().equals((Object)toCancel)) continue;
                this.registerAvailableReader(reader);
            }
        } else {
            ctx.fireUserEventTriggered(msg);
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.writeAndFlushNextMessageIfPossible(ctx.channel());
    }

    private void writeAndFlushNextMessageIfPossible(Channel channel) throws IOException {
        if (this.fatalError || !channel.isWritable()) {
            return;
        }
        InputChannel.BufferAndAvailability next = null;
        try {
            NetworkSequenceViewReader reader;
            while (true) {
                if ((reader = this.pollAvailableReader()) == null) {
                    return;
                }
                next = reader.getNextBuffer();
                if (next != null) break;
                if (!reader.isReleased()) continue;
                this.markAsReleased(reader.getReceiverId());
                Throwable cause = reader.getFailureCause();
                if (cause == null) continue;
                NettyMessage.ErrorResponse msg = new NettyMessage.ErrorResponse(new ProducerFailedException(cause), reader.getReceiverId());
                this.ctx.writeAndFlush((Object)msg);
            }
            if (next.moreAvailable()) {
                this.registerAvailableReader(reader);
            }
            NettyMessage.BufferResponse msg = new NettyMessage.BufferResponse(next.buffer(), reader.getSequenceNumber(), reader.getReceiverId(), next.buffersInBacklog());
            channel.writeAndFlush((Object)msg).addListener((GenericFutureListener)new WriteAndFlushNextMessageIfPossibleListener(reader));
            return;
        }
        catch (Throwable t) {
            if (next != null) {
                next.buffer().recycleBuffer();
            }
            throw new IOException(t.getMessage(), t);
        }
    }

    private void registerAvailableReader(NetworkSequenceViewReader reader) {
        this.availableReaders.add(reader);
        reader.setRegisteredAsAvailable(true);
    }

    @Nullable
    private NetworkSequenceViewReader pollAvailableReader() {
        NetworkSequenceViewReader reader = this.availableReaders.poll();
        if (reader != null) {
            reader.setRegisteredAsAvailable(false);
        }
        return reader;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.releaseAllResources();
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.handleException(ctx.channel(), cause);
    }

    private void handleException(Channel channel, Throwable cause) throws IOException {
        LOG.error("Encountered error while consuming partitions", cause);
        this.fatalError = true;
        this.releaseAllResources();
        if (channel.isActive()) {
            channel.writeAndFlush((Object)new NettyMessage.ErrorResponse(cause)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void releaseAllResources() throws IOException {
        for (NetworkSequenceViewReader reader : this.allReaders.values()) {
            reader.releaseAllResources();
            this.markAsReleased(reader.getReceiverId());
        }
        this.availableReaders.clear();
        this.allReaders.clear();
    }

    private void markAsReleased(InputChannelID receiverId) {
        this.released.add(receiverId);
    }

    boolean isMarkedReleased(InputChannelID receivedId) {
        return this.released.contains((Object)receivedId);
    }

    private class WriteAndFlushNextMessageIfPossibleListener
    implements ChannelFutureListener {
        private final NetworkSequenceViewReader reader;

        public WriteAndFlushNextMessageIfPossibleListener(NetworkSequenceViewReader reader) {
            this.reader = reader;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            try {
                if (!this.reader.isRegisteredAsAvailable() && this.reader.isAvailable()) {
                    PartitionRequestQueue.this.enqueueAvailableReader(this.reader);
                }
                if (future.isSuccess()) {
                    PartitionRequestQueue.this.writeAndFlushNextMessageIfPossible(future.channel());
                } else if (future.cause() != null) {
                    PartitionRequestQueue.this.handleException(future.channel(), future.cause());
                } else {
                    PartitionRequestQueue.this.handleException(future.channel(), new IllegalStateException("Sending cancelled by user."));
                }
            }
            catch (Throwable t) {
                PartitionRequestQueue.this.handleException(future.channel(), t);
            }
        }
    }
}

