/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolOwner;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.util.Preconditions;

public class FixedLengthBufferPool
implements BufferPool,
BufferRecycler {
    private final int numberOfBuffers;
    private final int memorySegmentSize;
    private final boolean freeOnDestroy;
    private final Queue<MemorySegment> memorySegments;
    private boolean isDestroyed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedLengthBufferPool(int numberOfBuffers, int memorySegmentSize, MemoryType memoryType) {
        Preconditions.checkArgument((numberOfBuffers > 0 ? 1 : 0) != 0, (Object)"There should be at least one buffer.");
        this.numberOfBuffers = numberOfBuffers;
        this.memorySegmentSize = memorySegmentSize;
        this.freeOnDestroy = true;
        Queue<MemorySegment> queue = this.memorySegments = new ArrayDeque<MemorySegment>(numberOfBuffers);
        synchronized (queue) {
            if (memoryType == MemoryType.HEAP) {
                for (int i = 0; i < numberOfBuffers; ++i) {
                    this.memorySegments.add(MemorySegmentFactory.allocateUnpooledSegment((int)memorySegmentSize));
                }
            } else if (memoryType == MemoryType.OFF_HEAP) {
                for (int i = 0; i < numberOfBuffers; ++i) {
                    ByteBuffer memory = ByteBuffer.allocateDirect(memorySegmentSize);
                    this.memorySegments.add(MemorySegmentFactory.wrapPooledOffHeapMemory((ByteBuffer)memory, null));
                }
            } else {
                throw new IllegalArgumentException("Unknown memory type " + memoryType);
            }
        }
    }

    public FixedLengthBufferPool(List<MemorySegment> memorySegments, boolean freeOnDestroy) {
        Preconditions.checkArgument((memorySegments.size() > 0 ? 1 : 0) != 0, (Object)"There should be at least one buffer.");
        this.numberOfBuffers = memorySegments.size();
        this.memorySegmentSize = memorySegments.get(0).size();
        this.freeOnDestroy = freeOnDestroy;
        this.memorySegments = new ArrayDeque<MemorySegment>(memorySegments);
    }

    @Override
    public void setBufferPoolOwner(BufferPoolOwner owner) {
    }

    @Override
    public void notifyBufferPoolOwnerReleased() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lazyDestroy() {
        Queue<MemorySegment> queue = this.memorySegments;
        synchronized (queue) {
            if (this.isDestroyed) {
                return;
            }
            this.memorySegments.notifyAll();
            if (this.freeOnDestroy) {
                for (MemorySegment memorySegment : this.memorySegments) {
                    memorySegment.free();
                }
            }
            this.memorySegments.clear();
            this.isDestroyed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Queue<MemorySegment> queue = this.memorySegments;
        synchronized (queue) {
            return this.isDestroyed;
        }
    }

    @Override
    public int getMemorySegmentSize() {
        return this.memorySegmentSize;
    }

    @Override
    public int getNumberOfRequiredMemorySegments() {
        return this.numberOfBuffers;
    }

    @Override
    public int getMaxNumberOfMemorySegments() {
        return this.numberOfBuffers;
    }

    @Override
    public int getNumBuffers() {
        return this.numberOfBuffers;
    }

    @Override
    public void setNumBuffers(int numBuffers) throws IOException {
        throw new UnsupportedOperationException("The size of FixedLengthBufferPool could not be changed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfAvailableMemorySegments() {
        Queue<MemorySegment> queue = this.memorySegments;
        synchronized (queue) {
            return this.memorySegments.size();
        }
    }

    @Override
    public int bestEffortGetNumOfUsedBuffers() {
        return this.numberOfBuffers - this.memorySegments.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(MemorySegment memorySegment) {
        Queue<MemorySegment> queue = this.memorySegments;
        synchronized (queue) {
            if (this.isDestroyed) {
                if (this.freeOnDestroy) {
                    memorySegment.free();
                }
            } else {
                this.memorySegments.add(memorySegment);
                this.memorySegments.notifyAll();
            }
        }
    }

    @Override
    public Buffer requestBuffer() throws IOException {
        try {
            return this.requestBufferBlocking();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Buffer requestBufferBlocking() throws InterruptedException {
        MemorySegment memorySegment = this.requestMemorySegmentBlocking();
        if (memorySegment == null) {
            return null;
        }
        return new NetworkBuffer(memorySegment, this);
    }

    public Buffer requestBufferUnblocking() throws InterruptedException {
        MemorySegment memorySegment = this.requestMemorySegmentUnblocking();
        if (memorySegment == null) {
            return null;
        }
        return new NetworkBuffer(memorySegment, this);
    }

    @Override
    public BufferBuilder requestBufferBuilderBlocking() throws InterruptedException {
        MemorySegment memorySegment = this.requestMemorySegmentBlocking();
        if (memorySegment == null) {
            return null;
        }
        return new BufferBuilder(memorySegment, this);
    }

    @Override
    public boolean addBufferListener(BufferListener listener) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemorySegment requestMemorySegmentUnblocking() throws InterruptedException {
        Queue<MemorySegment> queue = this.memorySegments;
        synchronized (queue) {
            return this.memorySegments.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemorySegment requestMemorySegmentBlocking() throws InterruptedException {
        Queue<MemorySegment> queue = this.memorySegments;
        synchronized (queue) {
            while (this.memorySegments.isEmpty()) {
                if (this.isDestroyed) {
                    return null;
                }
                this.memorySegments.wait(2000L);
            }
            return this.memorySegments.poll();
        }
    }
}

