/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.InternalResultPartition;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.taskexecutor.ResultPartitionReport;
import org.apache.flink.runtime.taskexecutor.ResultPartitionStatus;
import org.apache.flink.shaded.guava18.com.google.common.collect.HashBasedTable;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.guava18.com.google.common.collect.Table;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultPartitionManager
implements ResultPartitionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ResultPartitionManager.class);
    public final Table<ExecutionAttemptID, IntermediateResultPartitionID, InternalResultPartition> registeredPartitions = HashBasedTable.create();
    private boolean isShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResultPartition(InternalResultPartition partition) throws IOException {
        Table<ExecutionAttemptID, IntermediateResultPartitionID, InternalResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            Preconditions.checkState((!this.isShutdown ? 1 : 0) != 0, (Object)"Result partition manager already shut down.");
            ResultPartitionID partitionId = partition.getPartitionId();
            InternalResultPartition previous = (InternalResultPartition)this.registeredPartitions.put((Object)partitionId.getProducerId(), (Object)partitionId.getPartitionId(), (Object)partition);
            if (previous != null) {
                throw new IllegalStateException("Result partition already registered.");
            }
            LOG.debug("Registered {}.", (Object)partition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSubpartitionView createSubpartitionView(ResultPartitionID partitionId, int subpartitionIndex, BufferAvailabilityListener availabilityListener) throws IOException {
        Table<ExecutionAttemptID, IntermediateResultPartitionID, InternalResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            InternalResultPartition partition = (InternalResultPartition)this.registeredPartitions.get((Object)partitionId.getProducerId(), (Object)partitionId.getPartitionId());
            if (partition == null) {
                throw new PartitionNotFoundException(partitionId);
            }
            LOG.debug("Requesting subpartition {} of {}.", (Object)subpartitionIndex, (Object)partition);
            return partition.createSubpartitionView(subpartitionIndex, availabilityListener);
        }
    }

    public void releasePartitionsProducedBy(ExecutionAttemptID executionId) {
        this.releasePartitionsProducedBy(executionId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePartitionsProducedBy(ExecutionAttemptID executionId, Throwable cause) {
        Table<ExecutionAttemptID, IntermediateResultPartitionID, InternalResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            Map partitions = this.registeredPartitions.row((Object)executionId);
            for (InternalResultPartition partition : partitions.values()) {
                partition.release(cause);
            }
            for (IntermediateResultPartitionID partitionId : ImmutableList.copyOf(partitions.keySet())) {
                this.registeredPartitions.remove((Object)executionId, (Object)partitionId);
            }
            LOG.debug("Released all partitions produced by {}.", (Object)executionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePartitionsProducedBy(JobID jobId) {
        ArrayList<InternalResultPartition> matchedResultPartitions = new ArrayList<InternalResultPartition>();
        Table<ExecutionAttemptID, IntermediateResultPartitionID, InternalResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            for (InternalResultPartition partition : this.registeredPartitions.values()) {
                if (!partition.getJobId().equals((Object)jobId)) continue;
                matchedResultPartitions.add(partition);
            }
            for (InternalResultPartition partition : matchedResultPartitions) {
                partition.release();
                ResultPartitionID partitionId = partition.getPartitionId();
                this.registeredPartitions.remove((Object)partitionId.getProducerId(), (Object)partitionId.getPartitionId());
            }
            LOG.info("Released all partitions produced by job {}.", (Object)jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Table<ExecutionAttemptID, IntermediateResultPartitionID, InternalResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            LOG.debug("Releasing {} partitions because of shutdown.", (Object)this.registeredPartitions.values().size());
            for (InternalResultPartition partition : this.registeredPartitions.values()) {
                partition.release();
            }
            this.registeredPartitions.clear();
            this.isShutdown = true;
            LOG.debug("Successful shutdown.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultPartitionReport createResultPartitionReport() {
        ArrayList<ResultPartitionStatus> resultPartitionStatuses = new ArrayList<ResultPartitionStatus>();
        Table<ExecutionAttemptID, IntermediateResultPartitionID, InternalResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            for (InternalResultPartition partition : this.registeredPartitions.values()) {
                if (!partition.isFinished) continue;
                resultPartitionStatuses.add(new ResultPartitionStatus(partition.getJobId(), partition.getPartitionId()));
            }
        }
        return new ResultPartitionReport(resultPartitionStatuses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConsumedPartition(InternalResultPartition partition) {
        LOG.debug("Received consume notification from {}.", (Object)partition);
        if (partition.getPartitionType() == ResultPartitionType.PIPELINED) {
            InternalResultPartition previous;
            Table<ExecutionAttemptID, IntermediateResultPartitionID, InternalResultPartition> table = this.registeredPartitions;
            synchronized (table) {
                ResultPartitionID partitionId = partition.getPartitionId();
                previous = (InternalResultPartition)this.registeredPartitions.remove((Object)partitionId.getProducerId(), (Object)partitionId.getPartitionId());
            }
            if (partition == previous) {
                partition.release();
                LOG.debug("Released {}.", (Object)partition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areAllPartitionsReleased() {
        Table<ExecutionAttemptID, IntermediateResultPartitionID, InternalResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            for (ResultPartition partition : this.registeredPartitions.values()) {
                if (partition.isReleased()) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean containsResultPartitionOfJob(JobID jobId) {
        Table<ExecutionAttemptID, IntermediateResultPartitionID, InternalResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            for (InternalResultPartition partition : this.registeredPartitions.values()) {
                if (!partition.getJobId().equals((Object)jobId)) continue;
                return true;
            }
        }
        return false;
    }
}

