/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.io.network.partition.external.OsCachePolicy;

public class ExternalBlockShuffleServiceOptions {
    public static final ConfigOption<Integer> FLINK_SHUFFLE_SERVICE_PORT_KEY = ConfigOptions.key((String)"flink.shuffle-service.port").defaultValue((Object)14572).withDescription("The port of the shuffle service.");
    public static final ConfigOption<Integer> FLINK_SHUFFLE_SERVICE_DIRECT_MEMORY_LIMIT_IN_MB = ConfigOptions.key((String)"flink.shuffle-service.direct-memory-limit-in-mb").defaultValue((Object)300).withDescription("The direct memory consumed by the yarn shuffle service.");
    public static final ConfigOption<Integer> FLINK_SHUFFLE_SERVICE_HEAP_MEMORY_LIMIT_IN_MB = ConfigOptions.key((String)"flink.shuffle-service.heap-memory-limit-in-mb").defaultValue((Object)64).withDescription("The heap memory consumed by the yarn shuffle service");
    public static final ConfigOption<Integer> HEAP_MEMORY_THRESHOLD_TO_START_SHRINKING_IN_PERCENTAGE = ConfigOptions.key((String)"flink.shuffle-service.heap-memory-threshold-to-start-shrinking-in-percentage").defaultValue((Object)85).withDescription("Starts shrinking heap memory if the percentage of used heap memory footprint get higher than this threshold.");
    public static final ConfigOption<Long> MEMORY_SHRINKAGE_INTERVAL_IN_MS = ConfigOptions.key((String)"flink.shuffle-service.memory-shrinkage-interval-in-ms").defaultValue((Object)60000L).withDescription("The interval to check whether need to shrink memory in shuffle service, in milliseconds.");
    public static final ConfigOption<Long> OBJECT_MIN_IDLE_INTERVAL_TO_SHRINK_IN_MS = ConfigOptions.key((String)"flink.shuffle-service.object-min-idle-interval-to-shrink-in-ms").defaultValue((Object)10000L).withDescription("The min idle interval of a object to be able to be shrank in shuffle service, in milliseconds.");
    public static final ConfigOption<Long> SELF_CHECK_INTERVAL_IN_MS = ConfigOptions.key((String)"flink.shuffle-service.self-check-interval-in-ms").defaultValue((Object)15000L).withDescription("The interval to check the health of shuffle service by its runtime statistics, in milliseconds.");
    public static final ConfigOption<String> LOCAL_DIRS = ConfigOptions.key((String)"flink.shuffle-service.local-dirs").defaultValue((Object)"").withDescription("The list of local directories separated by comma. Each directory can be configured with the disk type ([TYPE] directory,...) or without the disk type (directory, ...). If not configured, the NodeManager local directories will be used and each directory will be treated as on HDD.");
    public static final ConfigOption<String> IO_THREAD_NUM_FOR_DISK_TYPE = ConfigOptions.key((String)"flink.shuffle-service.io-thread-number-for-disk-type").defaultValue((Object)"").withDescription("The list of disk types and thread numbers. Each disk type and the corresponding thread number is configured by TYPE_1: THREAD_1, TYPE_2: THREAD_2, ...");
    public static final ConfigOption<Integer> DEFAULT_IO_THREAD_NUM_PER_DISK = ConfigOptions.key((String)"flink.shuffle-service.default-io-thread-number-per-disk").defaultValue((Object)4).withDescription("The thread number for the default HDD disk type.");
    public static final ConfigOption<Integer> SERVER_THREAD_NUM = ConfigOptions.key((String)"flink.shuffle-service.server-thread-number").defaultValue((Object)0).withDescription("The number of netty IO threads. If it's not positive, the thread number is equal to the overall IO thread number");
    public static final ConfigOption<Integer> NETTY_MEMORY_IN_MB = ConfigOptions.key((String)"flink.shuffle-service.netty-memory-in-mb").defaultValue((Object)0).withDescription("The preferred number of netty IO threads. If it's positive, the netty memory size will be min(configured value, 4M * flink.shuffle-service.server-thread-number), otherwise the netty memory size will be min(1/2 * flink.shuffle-service.direct-memory-limit-in-mb, 4M * flink.shuffle-service.server-thread-number).");
    public static final ConfigOption<Integer> MEMORY_SIZE_PER_BUFFER_IN_BYTES = ConfigOptions.key((String)"flink.shuffle-service.memory-size-per-buffer-in-bytes").defaultValue((Object)32768).withDescription("");
    public static final ConfigOption<Long> WAIT_CREDIT_DELAY_IN_MS = ConfigOptions.key((String)"flink.shuffle-service.wait-credit-delay-in-ms").defaultValue((Object)0L).withDescription("");
    public static final ConfigOption<Long> DISK_SCAN_INTERVAL_IN_MS = ConfigOptions.key((String)"flink.shuffle-service.disk-scan-interval-in-ms").defaultValue((Object)15000L).withDescription("");
    public static final ConfigOption<Integer> CONSUMED_PARTITION_TTL_IN_SECONDS = ConfigOptions.key((String)"flink.shuffle-service.consumed-partition-ttl-in-seconds").defaultValue((Object)3600).withDescription("The time interval to delete the fully consumed shuffle data directories since they become inactive.");
    public static final ConfigOption<Integer> PARTIAL_CONSUMED_PARTITION_TTL_IN_SECONDS = ConfigOptions.key((String)"flink.shuffle-service.partial-consumed-partition-ttl-in-seconds").defaultValue((Object)43200).withDescription("The time interval to delete the partially consumed shuffle data directories since they become inactive.");
    public static final ConfigOption<Integer> UNCONSUMED_PARTITION_TTL_IN_SECONDS = ConfigOptions.key((String)"flink.shuffle-service.unconsumed-partition-ttl-in-seconds").defaultValue((Object)43200).withDescription("TThe time interval to delete the unconsumed shuffle data directories since they are ready to consume.");
    public static final ConfigOption<Integer> UNFINISHED_PARTITION_TTL_IN_SECONDS = ConfigOptions.key((String)"flink.shuffle-service.unfinished-partition-ttl-in-seconds").defaultValue((Object)3600).withDescription("The time interval to delete the writing shuffle data directories since the last writing.");
    public static final ConfigOption<String> SUBPARTITION_VIEW_SCHEDULER_CLASS = ConfigOptions.key((String)"flink.shuffle-service.subpartition-view-scheduler-class").defaultValue((Object)"org.apache.flink.runtime.io.network.partition.external.CreditBasedSubpartitionViewScheduler").withDescription("The scheduler to decide the next subpartition to serve.");
    public static final ConfigOption<String> OS_CACHE_POLICY = ConfigOptions.key((String)"flink.shuffle-service.os-cache-policy").defaultValue((Object)OsCachePolicy.NO_TREATMENT.toString()).withDescription("The OS cache policy while reading shuffle data, supported policies are " + OsCachePolicy.getSupportedOsCachePolicies() + ".");
    public static final ConfigOption<Long> MAX_READ_AHEAD_LENGTH_IN_BYTES = ConfigOptions.key((String)"flink.shuffle-service.os-cache-policy.read-ahead.max-read-ahead-length-in-bytes").defaultValue((Object)0x400000L).withDescription("The max length to read ahead in order to accelerate shuffle read. This configuration is valid only when " + OS_CACHE_POLICY.key() + " is configured as " + OsCachePolicy.READ_AHEAD.toString() + ".");
    public static final ConfigOption<String> LOCAL_RESULT_PARTITION_RESOLVER_CLASS = ConfigOptions.key((String)"flink.shuffle-service.internal.local-result-partition-resolver-class").noDefaultValue();

    private ExternalBlockShuffleServiceOptions() {
    }
}

