/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockResultPartitionMeta;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleUtils;
import org.apache.flink.runtime.io.network.partition.external.PartitionIndices;
import org.apache.flink.util.Preconditions;

public class HashPartitionIndices
implements PartitionIndices {
    private final FileSystem fileSystem;
    private final String partitionDir;
    private final Path indexFilePath;
    private final int subpartitionNum;
    @VisibleForTesting
    protected final AtomicReference<long[]> lengthArrayRef = new AtomicReference();

    public HashPartitionIndices(FileSystem fileSystem, String partitionDir, int subpartitionNum) {
        this.fileSystem = fileSystem;
        this.partitionDir = partitionDir;
        this.indexFilePath = new Path(ExternalBlockShuffleUtils.generateIndexPath(partitionDir, 0));
        this.subpartitionNum = subpartitionNum;
    }

    @Override
    public void initialize() throws IOException {
        this.lengthArrayRef.set(this.loadPartitionIndices());
    }

    @Override
    public ExternalBlockResultPartitionMeta.ExternalSubpartitionMeta getSubpartitionMeta(int subpartitionIndex) throws IOException {
        Preconditions.checkArgument((subpartitionIndex >= 0 && subpartitionIndex < this.subpartitionNum ? 1 : 0) != 0, (Object)"Invalid subpartition index.");
        long[] tmpLengthArray = this.lengthArrayRef.get();
        if (tmpLengthArray == null) {
            tmpLengthArray = this.loadPartitionIndices();
            this.lengthArrayRef.set(tmpLengthArray);
        }
        return new ExternalBlockResultPartitionMeta.ExternalSubpartitionMeta(new Path(ExternalBlockShuffleUtils.generateDataPath(this.partitionDir, subpartitionIndex)), 0L, tmpLengthArray[subpartitionIndex]);
    }

    @Override
    public long shrinkMemoryFootprint() {
        long[] tmpLengthArray = this.lengthArrayRef.get();
        if (tmpLengthArray != null) {
            this.lengthArrayRef.lazySet(null);
            return 8L * (long)this.subpartitionNum;
        }
        return 0L;
    }

    @Override
    public long getShrinkableMemoryFootprint() {
        long[] tmpLengthArray = this.lengthArrayRef.get();
        if (tmpLengthArray != null) {
            return 8L * (long)this.subpartitionNum;
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] loadPartitionIndices() throws IOException {
        if (!this.fileSystem.exists(this.indexFilePath)) {
            throw new IOException("Index file doesn't exist, file path: " + this.indexFilePath.getPath());
        }
        try (FSDataInputStream indexIn = this.fileSystem.open(this.indexFilePath);){
            DataInputViewStreamWrapper indexView = new DataInputViewStreamWrapper((InputStream)indexIn);
            int size = indexView.readInt();
            long[] tmpLengthArray = new long[this.subpartitionNum];
            int nextSubpartitionId = 0;
            for (int i = 0; i < size; ++i) {
                int subpartitionId = indexView.readInt();
                while (nextSubpartitionId < subpartitionId) {
                    tmpLengthArray[nextSubpartitionId++] = 0L;
                }
                if (nextSubpartitionId != subpartitionId) {
                    throw new IOException("Got invalid partition id, expected nextSubpartitionId: " + nextSubpartitionId + ", real subpartitionId: " + subpartitionId);
                }
                long startOffset = indexView.readLong();
                long lengthOfPartition = indexView.readLong();
                if (startOffset != 0L) {
                    throw new IOException("Offset should be zero in HASH_PARTITION_FILE, partition id: " + subpartitionId + ", real startOffset: " + startOffset);
                }
                tmpLengthArray[nextSubpartitionId++] = lengthOfPartition;
            }
            while (nextSubpartitionId < this.subpartitionNum) {
                tmpLengthArray[nextSubpartitionId++] = 0L;
            }
            assert (nextSubpartitionId == this.subpartitionNum);
            long[] lArray = tmpLengthArray;
            return lArray;
        }
        catch (IOException e) {
            throw new IOException("Cannot read index file, file path: " + this.indexFilePath.getPath(), e);
        }
    }
}

