/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.lang.reflect.Constructor;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleServiceConfiguration;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleServiceOptions;
import org.apache.flink.runtime.io.network.partition.external.LocalResultPartitionResolver;
import org.apache.flink.util.Preconditions;

public class LocalResultPartitionResolverFactory {
    static LocalResultPartitionResolver create(ExternalBlockShuffleServiceConfiguration shuffleServiceConfiguration) throws Exception {
        String className = shuffleServiceConfiguration.getConfiguration().getString(ExternalBlockShuffleServiceOptions.LOCAL_RESULT_PARTITION_RESOLVER_CLASS);
        Preconditions.checkArgument((className != null ? 1 : 0) != 0, (Object)("Need to configure for " + ExternalBlockShuffleServiceOptions.LOCAL_RESULT_PARTITION_RESOLVER_CLASS.key()));
        Class<?> cls = Class.forName(className);
        Constructor<?> constructor = cls.getDeclaredConstructor(ExternalBlockShuffleServiceConfiguration.class);
        LocalResultPartitionResolver resolver = (LocalResultPartitionResolver)constructor.newInstance(shuffleServiceConfiguration);
        return resolver;
    }
}

