/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

public class PartitionIndex {
    private final int subpartition;
    private final long startOffset;
    private final long length;
    private final transient long numRecords;

    public PartitionIndex(int subpartition, long startOffset, long length) {
        this(subpartition, startOffset, length, 0L);
    }

    public PartitionIndex(int subpartition, long startOffset, long length, long numRecords) {
        this.subpartition = subpartition;
        this.startOffset = startOffset;
        this.length = length;
        this.numRecords = numRecords;
    }

    public int getSubpartition() {
        return this.subpartition;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getLength() {
        return this.length;
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionIndex that = (PartitionIndex)o;
        return this.subpartition == that.subpartition && this.startOffset == that.startOffset && this.length == that.length && this.numRecords == that.numRecords;
    }

    public int hashCode() {
        int result = this.subpartition;
        result = 31 * result + (int)(this.startOffset ^ this.startOffset >>> 32);
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.numRecords ^ this.numRecords >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PartitionIndex :{ subpartition=").append(this.subpartition).append(", startOffset=").append(this.startOffset).append(", length=").append(this.length).append(", numRecords=").append(this.numRecords).append("}");
        return stringBuilder.toString();
    }
}

