/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external.writer;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.io.disk.ChannelBackendMutableObjectIterator;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SerializerManager;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.FixedLengthBufferPool;
import org.apache.flink.runtime.operators.sort.SortedDataFile;
import org.apache.flink.runtime.plugable.CopySerializationDelegate;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.util.Preconditions;

public class BufferSortedDataFile<T>
implements SortedDataFile<T> {
    private final FileIOChannel.ID channelID;
    private final int fileId;
    private final RecordSerializer<IOReadableWritable> recordSerializer;
    private final SerializationDelegate<T> serializationDelegate;
    private final CopySerializationDelegate<T> copySerializationDelegate;
    private final FixedLengthBufferPool bufferPool;
    private final BufferFileWriter streamFileWriter;
    private final Counter numBytesOut;
    private final Counter numBuffersOut;
    private BufferBuilder currentBufferBuilders;
    private long bytesWritten;
    private boolean isWritingFinished;

    public BufferSortedDataFile(FileIOChannel.ID channelID, int fileId, TypeSerializer<T> serializer, IOManager ioManager, List<MemorySegment> writeMemory, SerializerManager<SerializationDelegate<T>> serializerManager, Counter numBytesOut, Counter numBuffersOut) throws IOException {
        this.channelID = channelID;
        this.fileId = fileId;
        this.recordSerializer = serializerManager.getRecordSerializer();
        this.serializationDelegate = new SerializationDelegate<T>(serializer);
        this.copySerializationDelegate = new CopySerializationDelegate<T>(serializer);
        this.bufferPool = new FixedLengthBufferPool(writeMemory, false);
        this.streamFileWriter = ioManager.createStreamFileWriter(channelID);
        this.numBytesOut = numBytesOut;
        this.numBuffersOut = numBuffersOut;
    }

    @Override
    public FileIOChannel getWriteChannel() {
        return this.streamFileWriter;
    }

    @Override
    public FileIOChannel.ID getChannelID() {
        return this.channelID;
    }

    @Override
    public void writeRecord(T record) throws IOException {
        this.serializationDelegate.setInstance(record);
        this.recordSerializer.serializeRecord(this.serializationDelegate);
        this.copyToFile();
    }

    @Override
    public void copyRecord(DataInputView serializedRecord) throws IOException {
        Preconditions.checkState((!this.isWritingFinished ? 1 : 0) != 0, (Object)"");
        this.copySerializationDelegate.setInputView(serializedRecord);
        this.recordSerializer.serializeRecord(this.copySerializationDelegate);
        this.copyToFile();
    }

    @Override
    public void finishWriting() throws IOException {
        if (this.isWritingFinished) {
            return;
        }
        if (this.recordSerializer.hasSerializedData()) {
            this.flushInternalSerializer();
        }
        Preconditions.checkState((!this.recordSerializer.hasSerializedData() ? 1 : 0) != 0, (Object)"All data should be written at once");
        this.tryFinishCurrentBufferBuilder();
        this.streamFileWriter.close();
        this.isWritingFinished = true;
    }

    @Override
    public ChannelBackendMutableObjectIterator<T> createReader(List<MemorySegment> readMemory) throws IOException {
        return new ChannelBackendMutableObjectIterator<T>(){

            @Override
            public FileIOChannel getReaderChannel() {
                return null;
            }

            public T next(T reuse) throws IOException {
                return null;
            }

            public T next() throws IOException {
                return null;
            }
        };
    }

    public void flush() throws IOException {
        if (this.recordSerializer.hasSerializedData()) {
            this.flushInternalSerializer();
        }
        Preconditions.checkState((!this.recordSerializer.hasSerializedData() ? 1 : 0) != 0, (Object)"All data should be written at once");
        this.tryFinishCurrentBufferBuilder();
    }

    private void flushInternalSerializer() throws IOException {
        BufferBuilder bufferBuilder = this.getCurrentBufferBuilder();
        RecordSerializer.SerializationResult result = this.recordSerializer.flushToBufferBuilder(bufferBuilder);
        while (result.isFullBuffer()) {
            this.tryFinishCurrentBufferBuilder();
            if (result.isFullRecord()) break;
            bufferBuilder = this.getCurrentBufferBuilder();
            result = this.recordSerializer.flushToBufferBuilder(bufferBuilder);
        }
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public int getFileId() {
        return this.fileId;
    }

    private void copyToFile() throws IOException {
        this.recordSerializer.reset();
        BufferBuilder bufferBuilder = this.getCurrentBufferBuilder();
        RecordSerializer.SerializationResult result = this.recordSerializer.copyToBufferBuilder(bufferBuilder);
        while (result.isFullBuffer()) {
            this.tryFinishCurrentBufferBuilder();
            if (result.isFullRecord()) break;
            bufferBuilder = this.getCurrentBufferBuilder();
            result = this.recordSerializer.copyToBufferBuilder(bufferBuilder);
        }
    }

    private BufferBuilder getCurrentBufferBuilder() throws IOException {
        if (this.currentBufferBuilders == null) {
            try {
                this.currentBufferBuilders = this.bufferPool.requestBufferBuilderBlocking();
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to request buffer");
            }
            Preconditions.checkState((this.currentBufferBuilders != null ? 1 : 0) != 0, (Object)"Failed to request a buffer.");
        }
        return this.currentBufferBuilders;
    }

    private void tryFinishCurrentBufferBuilder() throws IOException {
        if (this.currentBufferBuilders != null) {
            int bufferSize = this.currentBufferBuilders.finish();
            BufferConsumer bufferConsumer = this.currentBufferBuilders.createBufferConsumer();
            Buffer buffer = bufferConsumer.build();
            this.streamFileWriter.writeBlock(buffer);
            this.bytesWritten += (long)bufferSize;
            if (this.numBytesOut != null) {
                this.numBytesOut.inc((long)bufferSize);
            }
            if (this.numBuffersOut != null) {
                this.numBuffersOut.inc();
            }
            bufferConsumer.close();
            this.currentBufferBuilders = null;
        }
    }
}

