/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external.writer;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.external.PartitionIndex;

public class PartitionIndexGenerator {
    private final int numberOfSubpartitions;
    private final List<PartitionIndex> partitionIndices;
    private long lastRecordsWritten = 0L;
    private int currentSubpartition = 0;
    private long currentSubpartitionStartOffset = 0L;

    public PartitionIndexGenerator(int numberOfSubpartitions) {
        this.numberOfSubpartitions = numberOfSubpartitions;
        this.partitionIndices = new ArrayList<PartitionIndex>(numberOfSubpartitions);
    }

    public void updatePartitionIndexBeforeWriting(int subpartition, long numBytesWrittenBeforeWriting, long numRecordsWrittenBeforeWriting) {
        if (subpartition != this.currentSubpartition) {
            PartitionIndex partitionIndex = new PartitionIndex(this.currentSubpartition, this.currentSubpartitionStartOffset, numBytesWrittenBeforeWriting - this.currentSubpartitionStartOffset, numRecordsWrittenBeforeWriting - this.lastRecordsWritten);
            this.partitionIndices.add(partitionIndex);
            for (int i = this.currentSubpartition + 1; i < subpartition; ++i) {
                this.partitionIndices.add(new PartitionIndex(i, numBytesWrittenBeforeWriting, 0L, 0L));
            }
            this.lastRecordsWritten = numRecordsWrittenBeforeWriting;
            this.currentSubpartition = subpartition;
            this.currentSubpartitionStartOffset = numBytesWrittenBeforeWriting;
        }
    }

    public void finishWriting(long numBytesWrittenBefore, long numRecordsWrittenBefore) {
        PartitionIndex partitionIndex = new PartitionIndex(this.currentSubpartition, this.currentSubpartitionStartOffset, numBytesWrittenBefore - this.currentSubpartitionStartOffset, numRecordsWrittenBefore - this.lastRecordsWritten);
        this.partitionIndices.add(partitionIndex);
        for (int i = this.currentSubpartition + 1; i < this.numberOfSubpartitions; ++i) {
            this.partitionIndices.add(new PartitionIndex(i, numBytesWrittenBefore, 0L, 0L));
        }
    }

    public List<PartitionIndex> getPartitionIndices() {
        return this.partitionIndices;
    }
}

