/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.SchedulingMode;

public class JobEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobVertex target;
    private final DistributionPattern distributionPattern;
    private IntermediateDataSet source;
    private IntermediateDataSetID sourceId;
    private String shipStrategyName;
    private String preProcessingOperationName;
    private String operatorLevelCachingDescription;
    private transient Map<Integer, Collection<ExecutionVertexID>> consumerExecutionVerticesCache;
    private SchedulingMode schedulingMode;

    public JobEdge(IntermediateDataSet source, JobVertex target, DistributionPattern distributionPattern) {
        if (source == null || target == null || distributionPattern == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.distributionPattern = distributionPattern;
        this.source = source;
        this.sourceId = source.getId();
    }

    public JobEdge(IntermediateDataSetID sourceId, JobVertex target, DistributionPattern distributionPattern) {
        if (sourceId == null || target == null || distributionPattern == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.distributionPattern = distributionPattern;
        this.sourceId = sourceId;
    }

    public IntermediateDataSet getSource() {
        return this.source;
    }

    public JobVertex getTarget() {
        return this.target;
    }

    public DistributionPattern getDistributionPattern() {
        return this.distributionPattern;
    }

    public IntermediateDataSetID getSourceId() {
        return this.sourceId;
    }

    public boolean isIdReference() {
        return this.source == null;
    }

    public void connecDataSet(IntermediateDataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        if (this.source != null) {
            throw new IllegalStateException("The edge is already connected.");
        }
        if (!dataSet.getId().equals((Object)this.sourceId)) {
            throw new IllegalArgumentException("The data set to connect does not match the sourceId.");
        }
        this.source = dataSet;
    }

    public String getShipStrategyName() {
        return this.shipStrategyName;
    }

    public void setShipStrategyName(String shipStrategyName) {
        this.shipStrategyName = shipStrategyName;
    }

    public String getPreProcessingOperationName() {
        return this.preProcessingOperationName;
    }

    public void setPreProcessingOperationName(String preProcessingOperationName) {
        this.preProcessingOperationName = preProcessingOperationName;
    }

    public String getOperatorLevelCachingDescription() {
        return this.operatorLevelCachingDescription;
    }

    public void setOperatorLevelCachingDescription(String operatorLevelCachingDescription) {
        this.operatorLevelCachingDescription = operatorLevelCachingDescription;
    }

    public SchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    public void setSchedulingMode(SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    public void clearConsumerExecutionVerticesCache() {
        if (this.consumerExecutionVerticesCache != null) {
            this.consumerExecutionVerticesCache.clear();
        }
    }

    public Collection<ExecutionVertexID> getConsumerExecutionVertices(int partitionNumber) {
        Collection<ExecutionVertexID> consumers;
        if (this.consumerExecutionVerticesCache == null) {
            this.consumerExecutionVerticesCache = new HashMap<Integer, Collection<ExecutionVertexID>>();
        }
        if (this.consumerExecutionVerticesCache.containsKey(partitionNumber)) {
            return this.consumerExecutionVerticesCache.get(partitionNumber);
        }
        switch (this.distributionPattern) {
            case POINTWISE: {
                consumers = this.getConsumerExecutionVerticesPointwise(partitionNumber);
                break;
            }
            case ALL_TO_ALL: {
                consumers = this.getConsumerExecutionVerticesAllToAll();
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized distribution pattern.");
            }
        }
        this.consumerExecutionVerticesCache.put(partitionNumber, consumers);
        return consumers;
    }

    private Collection<ExecutionVertexID> getConsumerExecutionVerticesPointwise(int partitionNumber) {
        int sourceCount = this.source.getProducer().getParallelism();
        int targetCount = this.target.getParallelism();
        ArrayList<ExecutionVertexID> consumerVertices = new ArrayList<ExecutionVertexID>();
        if (sourceCount == targetCount) {
            consumerVertices.add(new ExecutionVertexID(this.target.getID(), partitionNumber));
        } else if (sourceCount > targetCount) {
            int vertexSubtaskIndex;
            if (sourceCount % targetCount == 0) {
                int factor = sourceCount / targetCount;
                vertexSubtaskIndex = partitionNumber / factor;
            } else {
                float factor = (float)sourceCount / (float)targetCount;
                int mirrorPartitionNumber = sourceCount - 1 - partitionNumber;
                int mirrorVertexSubTaskIndex = (int)((float)mirrorPartitionNumber / factor);
                vertexSubtaskIndex = targetCount - 1 - mirrorVertexSubTaskIndex;
            }
            consumerVertices.add(new ExecutionVertexID(this.target.getID(), vertexSubtaskIndex));
        } else if (targetCount % sourceCount == 0) {
            int factor = targetCount / sourceCount;
            int startIndex = partitionNumber * factor;
            for (int i = 0; i < factor; ++i) {
                consumerVertices.add(new ExecutionVertexID(this.target.getID(), startIndex + i));
            }
        } else {
            float factor = (float)targetCount / (float)sourceCount;
            int mirrorPartitionNumber = sourceCount - 1 - partitionNumber;
            int start2 = (int)((float)mirrorPartitionNumber * factor);
            int end = mirrorPartitionNumber == sourceCount - 1 ? targetCount : (int)((float)(mirrorPartitionNumber + 1) * factor);
            for (int i = 0; i < end - start2; ++i) {
                int mirrorVertexSubTaskIndex = start2 + i;
                int vertexSubtaskIndex = targetCount - 1 - mirrorVertexSubTaskIndex;
                consumerVertices.add(new ExecutionVertexID(this.target.getID(), vertexSubtaskIndex));
            }
        }
        return consumerVertices;
    }

    private Collection<ExecutionVertexID> getConsumerExecutionVerticesAllToAll() {
        ArrayList<ExecutionVertexID> consumerVertices = new ArrayList<ExecutionVertexID>();
        for (int i = 0; i < this.target.getParallelism(); ++i) {
            consumerVertices.add(new ExecutionVertexID(this.target.getID(), i));
        }
        return consumerVertices;
    }

    public String toString() {
        return String.format("%s --> %s [%s]", new Object[]{this.sourceId, this.target, this.distributionPattern.name()});
    }
}

