/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.flink.runtime.jobgraph.FormatUtil;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.util.TaskConfig;

public class OutputFormatVertex
extends JobVertex {
    private static final long serialVersionUID = 1L;
    private String formatDescription;
    private OperatorID sinkOperatorId;

    public OutputFormatVertex(String name) {
        this(name, (OperatorID)null);
    }

    public OutputFormatVertex(String name, @Nullable OperatorID sinkOperatorId) {
        super(name);
        this.sinkOperatorId = sinkOperatorId != null ? sinkOperatorId : OperatorID.fromJobVertexID(this.getID());
    }

    public void setFormatDescription(String formatDescription) {
        this.formatDescription = formatDescription;
    }

    public String getFormatDescription() {
        return this.formatDescription;
    }

    @Override
    public void initializeOnMaster(ClassLoader loader) throws Exception {
        TaskConfig cfg = new TaskConfig(this.getConfiguration());
        FormatUtil.OutputFormatStub stub = new FormatUtil.OutputFormatStub(cfg, loader, this.sinkOperatorId);
        FormatUtil.initializeOutputFormatsOnMaster(this, stub, Collections.singletonMap(this.sinkOperatorId, this.formatDescription));
    }

    @Override
    public void finalizeOnMaster(ClassLoader loader) throws Exception {
        TaskConfig cfg = new TaskConfig(this.getConfiguration());
        FormatUtil.OutputFormatStub stub = new FormatUtil.OutputFormatStub(cfg, loader, this.sinkOperatorId);
        FormatUtil.finalizeOutputFormatsOnMaster(this, stub, Collections.singletonMap(this.sinkOperatorId, this.formatDescription));
    }
}

