/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.SerializedValue;

public class JobResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobID jobId;
    private final Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults;
    private final long netRuntime;
    @Nullable
    private final SerializedThrowable serializedThrowable;

    private JobResult(JobID jobId, Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults, long netRuntime, @Nullable SerializedThrowable serializedThrowable) {
        Preconditions.checkArgument((netRuntime >= 0L ? 1 : 0) != 0, (Object)"netRuntime must be greater than or equals 0");
        this.jobId = Objects.requireNonNull(jobId);
        this.accumulatorResults = Objects.requireNonNull(accumulatorResults);
        this.netRuntime = netRuntime;
        this.serializedThrowable = serializedThrowable;
    }

    public boolean isSuccess() {
        return this.serializedThrowable == null;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public Map<String, SerializedValue<OptionalFailure<Object>>> getAccumulatorResults() {
        return this.accumulatorResults;
    }

    public long getNetRuntime() {
        return this.netRuntime;
    }

    public Optional<SerializedThrowable> getSerializedThrowable() {
        return Optional.ofNullable(this.serializedThrowable);
    }

    public JobExecutionResult toJobExecutionResult(ClassLoader classLoader) throws WrappedJobException, IOException, ClassNotFoundException {
        if (this.serializedThrowable != null) {
            Throwable throwable = this.serializedThrowable.deserializeError(classLoader);
            throw new WrappedJobException(throwable);
        }
        return new JobExecutionResult(this.jobId, this.netRuntime, AccumulatorHelper.deserializeAccumulators(this.accumulatorResults, (ClassLoader)classLoader));
    }

    public static JobResult createFrom(AccessExecutionGraph accessExecutionGraph) {
        ErrorInfo errorInfo;
        JobID jobId = accessExecutionGraph.getJobID();
        JobStatus jobStatus = accessExecutionGraph.getState();
        Preconditions.checkArgument((boolean)jobStatus.isGloballyTerminalState(), (Object)("The job " + accessExecutionGraph.getJobName() + '(' + jobId + ") is not in a globally terminal state. It is in state " + (Object)((Object)jobStatus) + '.'));
        Builder builder = new Builder();
        builder.jobId(jobId);
        long netRuntime = accessExecutionGraph.getStatusTimestamp(jobStatus) - accessExecutionGraph.getStatusTimestamp(JobStatus.CREATED);
        long guardedNetRuntime = Math.max(netRuntime, 0L);
        builder.netRuntime(guardedNetRuntime);
        builder.accumulatorResults(accessExecutionGraph.getAccumulatorsSerialized());
        if (jobStatus != JobStatus.FINISHED && (errorInfo = accessExecutionGraph.getFailureInfo()) != null) {
            builder.serializedThrowable(errorInfo.getException());
        }
        return builder.build();
    }

    public static final class WrappedJobException
    extends FlinkException {
        private static final long serialVersionUID = 6535061898650156019L;

        public WrappedJobException(Throwable cause) {
            super(cause);
        }
    }

    @Internal
    public static class Builder {
        private JobID jobId;
        private Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults;
        private long netRuntime = -1L;
        private SerializedThrowable serializedThrowable;

        public Builder jobId(JobID jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder accumulatorResults(Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults) {
            this.accumulatorResults = accumulatorResults;
            return this;
        }

        public Builder netRuntime(long netRuntime) {
            this.netRuntime = netRuntime;
            return this;
        }

        public Builder serializedThrowable(SerializedThrowable serializedThrowable) {
            this.serializedThrowable = serializedThrowable;
            return this;
        }

        public JobResult build() {
            return new JobResult(this.jobId, this.accumulatorResults == null ? Collections.emptyMap() : this.accumulatorResults, this.netRuntime, this.serializedThrowable);
        }
    }
}

