/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.failover;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.failover.OperationLog;
import org.apache.flink.runtime.jobmaster.failover.OperationLogType;
import org.apache.flink.runtime.jobmaster.failover.ResultDescriptor;
import org.apache.flink.util.Preconditions;

public class ExecutionGraphOperationLog
extends OperationLog {
    private final ExecutionVertexID executionVertexID;
    private final ExecutionState executionState;
    @Nullable
    private final Map<OperatorID, List<InputSplit>> consumedInputs;
    @Nullable
    private final ResultDescriptor resultDescriptor;
    @Nullable
    private final Map<String, Accumulator<?, ?>> userAccumulators;
    @Nullable
    private final IOMetrics metrics;

    public ExecutionGraphOperationLog(ExecutionVertexID executionVertexID, ExecutionState executionState, @Nullable Map<OperatorID, List<InputSplit>> inputSplits, @Nullable ResultDescriptor resultDescriptor, @Nullable Map<String, Accumulator<?, ?>> userAccumulators, @Nullable IOMetrics metrics) {
        super(OperationLogType.GRAPH_MANAGER);
        this.executionVertexID = (ExecutionVertexID)Preconditions.checkNotNull((Object)executionVertexID);
        this.executionState = (ExecutionState)((Object)Preconditions.checkNotNull((Object)((Object)executionState)));
        this.consumedInputs = inputSplits;
        this.resultDescriptor = resultDescriptor;
        this.userAccumulators = userAccumulators;
        this.metrics = metrics;
    }

    public ExecutionVertexID getExecutionVertexID() {
        return this.executionVertexID;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    @Nullable
    public Map<OperatorID, List<InputSplit>> getConsumedInputs() {
        return this.consumedInputs;
    }

    @Nullable
    public ResultDescriptor getResultDescriptor() {
        return this.resultDescriptor;
    }

    @Nullable
    public Map<String, Accumulator<?, ?>> getUserAccumulators() {
        return this.userAccumulators;
    }

    @Nullable
    public IOMetrics getMetrics() {
        return this.metrics;
    }
}

