/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.failover;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.jobmaster.failover.OperationLog;
import org.apache.flink.runtime.jobmaster.failover.OperationLogStore;
import org.apache.flink.runtime.jobmaster.failover.OperationLogType;
import org.apache.flink.runtime.jobmaster.failover.Replayable;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class OperationLogManager {
    private final OperationLogStore operationLogStore;
    private final Map<OperationLogType, Replayable> opLogTypeToReplayHandlers;
    private volatile boolean replaying = false;

    public OperationLogManager(OperationLogStore store) {
        this.operationLogStore = (OperationLogStore)Preconditions.checkNotNull((Object)store);
        this.opLogTypeToReplayHandlers = new HashMap<OperationLogType, Replayable>(1);
    }

    public void start() {
        this.operationLogStore.start();
    }

    public void stop() {
        this.operationLogStore.stop();
    }

    public void clear() {
        this.operationLogStore.clear();
        this.replaying = false;
    }

    public boolean isReplaying() {
        return this.replaying;
    }

    public void registerLogHandler(OperationLogType type, Replayable logHandler) {
        this.opLogTypeToReplayHandlers.put(type, logHandler);
    }

    public void writeOpLog(OperationLog opLog) {
        this.operationLogStore.writeOpLog(opLog);
    }

    public void replay() {
        OperationLog opLog;
        this.replaying = true;
        while ((opLog = this.operationLogStore.readOpLog()) != null) {
            Replayable replayHandler = this.opLogTypeToReplayHandlers.get(opLog.getType());
            if (replayHandler != null) {
                replayHandler.replayOpLog(opLog);
                continue;
            }
            throw new FlinkRuntimeException("Can not find replayer for log type " + opLog.getType());
        }
        this.replaying = false;
    }
}

