/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;

public class DualKeyMap<A, B, V> {
    private final HashMap<A, Tuple2<B, V>> aMap;
    private final HashMap<B, A> bMap;
    private transient Collection<V> values;

    public DualKeyMap(int initialCapacity) {
        this.aMap = new HashMap(initialCapacity);
        this.bMap = new HashMap(initialCapacity);
    }

    public int size() {
        return this.aMap.size();
    }

    public V getKeyA(A aKey) {
        Tuple2<B, V> value = this.aMap.get(aKey);
        if (value != null) {
            return (V)value.f1;
        }
        return null;
    }

    public V getKeyB(B bKey) {
        A aKey = this.bMap.get(bKey);
        if (aKey != null) {
            return (V)this.aMap.get(aKey).f1;
        }
        return null;
    }

    public V put(A aKey, B bKey, V value) {
        Tuple2 aValue = this.aMap.put(aKey, Tuple2.of(bKey, value));
        this.bMap.put(bKey, aKey);
        if (aValue != null) {
            return (V)aValue.f1;
        }
        return null;
    }

    public boolean containsKeyA(A aKey) {
        return this.aMap.containsKey(aKey);
    }

    public boolean containsKeyB(B bKey) {
        return this.bMap.containsKey(bKey);
    }

    public V removeKeyA(A aKey) {
        Tuple2<B, V> aValue = this.aMap.remove(aKey);
        if (aValue != null) {
            this.bMap.remove(aValue.f0);
            return (V)aValue.f1;
        }
        return null;
    }

    public V removeKeyB(B bKey) {
        A aKey = this.bMap.remove(bKey);
        if (aKey != null) {
            Tuple2<B, V> aValue = this.aMap.remove(aKey);
            if (aValue != null) {
                return (V)aValue.f1;
            }
            return null;
        }
        return null;
    }

    public Collection<V> values() {
        Values vs = this.values;
        if (vs == null) {
            this.values = vs = new Values();
        }
        return vs;
    }

    public Set<A> keySetA() {
        return this.aMap.keySet();
    }

    public Set<B> keySetB() {
        return this.bMap.keySet();
    }

    public void clear() {
        this.aMap.clear();
        this.bMap.clear();
    }

    private final class ValueIterator
    implements Iterator<V> {
        private final Iterator<Tuple2<B, V>> iterator;

        private ValueIterator() {
            this.iterator = DualKeyMap.this.aMap.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            Tuple2 value = this.iterator.next();
            return value.f1;
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return DualKeyMap.this.aMap.size();
        }
    }
}

