/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.checkpoint;

import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.checkpoint.AbstractCheckpointMessage;

public class NotifyCheckpointAbort
extends AbstractCheckpointMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long timestamp;

    public NotifyCheckpointAbort(JobID job, ExecutionAttemptID taskExecutionId, long checkpointId, long timestamp) {
        super(job, taskExecutionId, checkpointId);
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (int)(this.timestamp ^ this.timestamp >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NotifyCheckpointAbort) {
            NotifyCheckpointAbort that = (NotifyCheckpointAbort)o;
            return this.timestamp == that.timestamp && super.equals(o);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("AbortCheckpoint %d for (%s/%s)", new Object[]{this.getCheckpointId(), this.getJob(), this.getTaskExecutionId()});
    }
}

