/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.shipping;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.util.Collector;

public class OutputCollector<T>
implements Collector<T> {
    private final RecordWriter<T>[] writers;

    public OutputCollector(List<RecordWriter<T>> writers) {
        this.writers = writers.toArray(new RecordWriter[writers.size()]);
    }

    public void collect(T record) {
        if (record != null) {
            try {
                for (RecordWriter<T> writer : this.writers) {
                    writer.emit(record);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Emitting the record caused an I/O exception: " + e.getMessage(), e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Emitting the record was interrupted: " + e.getMessage(), e);
            }
        } else {
            throw new NullPointerException("The system does not support records that are null.Null values are only supported as fields inside other objects.");
        }
    }

    public void close() {
        for (RecordWriter<T> writer : this.writers) {
            writer.clearBuffers();
            writer.flushAll();
        }
    }

    public List<RecordWriter<T>> getWriters() {
        return Collections.unmodifiableList(Arrays.asList(this.writers));
    }
}

