/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.ChannelBackendMutableObjectIterator;
import org.apache.flink.runtime.io.disk.ChannelReaderInputViewIterator;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.operators.sort.SortedDataFile;
import org.apache.flink.util.Preconditions;

public class BlockSortedDataFile<T>
implements SortedDataFile<T> {
    private final FileIOChannel.ID channelID;
    private final TypeSerializer<T> serialize;
    private final IOManager ioManager;
    private final BlockChannelWriter<MemorySegment> blockFileWriter;
    private final ChannelWriterOutputView channelWriterOutputView;
    private boolean isWritingFinished;

    public BlockSortedDataFile(FileIOChannel.ID channelID, TypeSerializer<T> serialize, IOManager ioManager, List<MemorySegment> writeMemory) throws IOException {
        Preconditions.checkArgument((writeMemory.size() > 0 ? 1 : 0) != 0, (Object)"Write memory are required for the BlockSortedDataFile.");
        this.channelID = channelID;
        this.serialize = serialize;
        this.ioManager = ioManager;
        this.blockFileWriter = ioManager.createBlockChannelWriter(channelID);
        this.channelWriterOutputView = new ChannelWriterOutputView(this.blockFileWriter, writeMemory, writeMemory.get(0).size());
    }

    @Override
    public FileIOChannel getWriteChannel() {
        return this.blockFileWriter;
    }

    @Override
    public FileIOChannel.ID getChannelID() {
        return this.channelID;
    }

    @Override
    public void writeRecord(T record) throws IOException {
        Preconditions.checkState((!this.isWritingFinished ? 1 : 0) != 0, (Object)"");
        this.serialize.serialize(record, (DataOutputView)this.channelWriterOutputView);
    }

    @Override
    public void copyRecord(DataInputView serializedRecord) throws IOException {
        Preconditions.checkState((!this.isWritingFinished ? 1 : 0) != 0, (Object)"");
        this.serialize.copy(serializedRecord, (DataOutputView)this.channelWriterOutputView);
    }

    @Override
    public long getBytesWritten() throws IOException {
        return this.channelWriterOutputView.getBytesWritten();
    }

    @Override
    public void finishWriting() throws IOException {
        if (this.isWritingFinished) {
            return;
        }
        this.channelWriterOutputView.close();
        this.isWritingFinished = true;
    }

    @Override
    public ChannelBackendMutableObjectIterator<T> createReader(List<MemorySegment> readMemory) throws IOException {
        Preconditions.checkState((boolean)this.isWritingFinished, (Object)"");
        BlockChannelReader<MemorySegment> reader = this.ioManager.createBlockChannelReader(this.channelID);
        ChannelReaderInputView inputView = new ChannelReaderInputView(reader, readMemory, this.channelWriterOutputView.getBlockCount(), false);
        return new ChannelReaderInputViewIterator<T>(inputView, null, this.serialize);
    }
}

