/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;

public class ChannelDeleteRegistry<T> {
    private final HashSet<FileIOChannel> openChannels = new HashSet(64);
    private final HashSet<FileIOChannel.ID> channelsToBeDelete = new HashSet(64);

    public void registerOpenChannel(FileIOChannel channel) {
        this.openChannels.add(channel);
    }

    public void unregisterOpenChannel(FileIOChannel channel) {
        this.openChannels.remove(channel);
    }

    public void registerChannelToBeDelete(FileIOChannel.ID file) {
        this.channelsToBeDelete.add(file);
    }

    public void unregisterChannelToBeDelete(FileIOChannel.ID file) {
        this.channelsToBeDelete.remove(file);
    }

    void clearOpenFiles() {
        while (!this.openChannels.isEmpty()) {
            try {
                Iterator<FileIOChannel> channels = this.openChannels.iterator();
                while (channels.hasNext()) {
                    FileIOChannel channel = channels.next();
                    channels.remove();
                    channel.closeAndDelete();
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    void clearFiles() {
        while (!this.channelsToBeDelete.isEmpty()) {
            try {
                Iterator<FileIOChannel.ID> channels = this.channelsToBeDelete.iterator();
                while (channels.hasNext()) {
                    FileIOChannel.ID channel = channels.next();
                    channels.remove();
                    try {
                        File f = new File(channel.getPath());
                        if (!f.exists()) continue;
                        f.delete();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
            }
        }
    }
}

