/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.Duration;

public class ResourceManagerConfiguration {
    private final Time timeout;
    private final Time heartbeatInterval;
    private final Time resultPartitionDisconnectJmTimeout;
    private final double maxTotalCpuCore;
    private final int maxTotalMemoryMb;

    @VisibleForTesting
    public ResourceManagerConfiguration(Time timeout, Time heartbeatInterval) {
        this(timeout, heartbeatInterval, Time.milliseconds((long)Integer.MAX_VALUE), Double.MAX_VALUE, Integer.MAX_VALUE);
    }

    @VisibleForTesting
    public ResourceManagerConfiguration(Time timeout, Time heartbeatInterval, double maxTotalCpuCore, int maxTotalMemoryMb) {
        this(timeout, heartbeatInterval, Time.milliseconds((long)Integer.MAX_VALUE), maxTotalCpuCore, maxTotalMemoryMb);
    }

    public ResourceManagerConfiguration(Time timeout, Time heartbeatInterval, Time resultPartitionDisconnectJmTimeout, double maxTotalCpuCore, int maxTotalMemoryMb) {
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout, (String)"timeout");
        this.heartbeatInterval = (Time)Preconditions.checkNotNull((Object)heartbeatInterval, (String)"heartbeatInterval");
        this.resultPartitionDisconnectJmTimeout = resultPartitionDisconnectJmTimeout;
        this.maxTotalCpuCore = maxTotalCpuCore;
        this.maxTotalMemoryMb = maxTotalMemoryMb;
    }

    public Time getTimeout() {
        return this.timeout;
    }

    public Time getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public Time getResultPartitionDisconnectJmTimeout() {
        return this.resultPartitionDisconnectJmTimeout;
    }

    public double getMaxTotalCpuCore() {
        return this.maxTotalCpuCore;
    }

    public int getMaxTotalMemoryMb() {
        return this.maxTotalMemoryMb;
    }

    public static ResourceManagerConfiguration fromConfiguration(Configuration configuration) throws ConfigurationException {
        Time heartbeatInterval;
        Time timeout;
        String strTimeout = configuration.getString(AkkaOptions.ASK_TIMEOUT);
        try {
            timeout = Time.milliseconds((long)Duration.apply((String)strTimeout).toMillis());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Could not parse the resource manager's timeout value " + AkkaOptions.ASK_TIMEOUT + '.', (Throwable)e);
        }
        String strHeartbeatInterval = configuration.getString(AkkaOptions.WATCH_HEARTBEAT_INTERVAL);
        try {
            heartbeatInterval = Time.milliseconds((long)Duration.apply((String)strHeartbeatInterval).toMillis());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Could not parse the resource manager's heartbeat interval value " + AkkaOptions.WATCH_HEARTBEAT_INTERVAL + '.', (Throwable)e);
        }
        Time resultPartitionDisconnectJmTimeout = Time.milliseconds((long)configuration.getLong(ResourceManagerOptions.RESULT_PARTITION_DISCONNECT_JM_TIMEOUT));
        double maxTotalCpuCore = configuration.getDouble(ResourceManagerOptions.MAX_TOTAL_RESOURCE_LIMIT_CPU_CORE);
        int maxTotalMemoryMb = configuration.getInteger(ResourceManagerOptions.MAX_TOTAL_RESOURCE_LIMIT_MEMORY_MB);
        return new ResourceManagerConfiguration(timeout, heartbeatInterval, resultPartitionDisconnectJmTimeout, maxTotalCpuCore, maxTotalMemoryMb);
    }
}

