/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.ResourceOverview;
import org.apache.flink.runtime.resourcemanager.SlotRequest;
import org.apache.flink.runtime.resourcemanager.placementconstraint.PlacementConstraint;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.taskexecutor.ResultPartitionStatus;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceReport;
import org.apache.flink.runtime.util.FileOffsetRange;

public interface ResourceManagerGateway
extends FencedRpcGateway<ResourceManagerId> {
    public CompletableFuture<RegistrationResponse> registerJobManager(JobMasterId var1, ResourceID var2, String var3, JobID var4, @RpcTimeout Time var5);

    public CompletableFuture<Acknowledge> setPlacementConstraints(JobID var1, List<PlacementConstraint> var2, @RpcTimeout Time var3);

    public CompletableFuture<Acknowledge> requestSlot(JobMasterId var1, SlotRequest var2, @RpcTimeout Time var3);

    public CompletableFuture<List<Tuple2<Acknowledge, Throwable>>> requestSlots(JobMasterId var1, List<SlotRequest> var2, @RpcTimeout Time var3);

    public void cancelSlotRequest(AllocationID var1);

    public CompletableFuture<RegistrationResponse> registerTaskExecutor(String var1, ResourceID var2, int var3, HardwareDescription var4, @RpcTimeout Time var5);

    public CompletableFuture<Acknowledge> sendTaskExecutorResourceReport(ResourceID var1, InstanceID var2, TaskExecutorResourceReport var3, @RpcTimeout Time var4);

    public void notifyResultPartitionFinished(ResourceID var1, InstanceID var2, ResultPartitionStatus var3);

    public void notifySlotAvailable(InstanceID var1, SlotID var2, AllocationID var3);

    public void registerInfoMessageListener(String var1);

    public void unRegisterInfoMessageListener(String var1);

    public CompletableFuture<Acknowledge> deregisterApplication(ApplicationStatus var1, @Nullable String var2);

    public CompletableFuture<Integer> getNumberOfRegisteredTaskManagers();

    public void heartbeatFromTaskManager(ResourceID var1, TaskExecutorResourceReport var2);

    public void heartbeatFromJobManager(ResourceID var1);

    public void disconnectTaskManager(ResourceID var1, Exception var2);

    public void disconnectJobManager(JobID var1, Exception var2);

    public void releaseResultPartitions(JobID var1);

    public CompletableFuture<Collection<TaskManagerInfo>> requestTaskManagerInfo(@RpcTimeout Time var1);

    public CompletableFuture<TaskManagerInfo> requestTaskManagerInfo(ResourceID var1, @RpcTimeout Time var2);

    public CompletableFuture<ResourceOverview> requestResourceOverview(@RpcTimeout Time var1);

    public CompletableFuture<Collection<Tuple2<ResourceID, String>>> requestTaskManagerMetricQueryServicePaths(@RpcTimeout Time var1);

    public CompletableFuture<TransientBlobKey> requestTaskManagerFileUpload(ResourceID var1, String var2, FileOffsetRange var3, @RpcTimeout Time var4);

    public CompletableFuture<Tuple2<TransientBlobKey, Long>> requestTaskManagerFileUploadReturnLength(ResourceID var1, String var2, FileOffsetRange var3, @RpcTimeout Time var4);

    public CompletableFuture<Collection<Tuple2<String, Long>>> requestTaskManagerLogList(ResourceID var1, @RpcTimeout Time var2);

    public CompletableFuture<Tuple2<String, Long>> requestJmx(ResourceID var1, @RpcTimeout Time var2);

    public CompletableFuture<Tuple2<String, String>> requestTmLogAndStdoutFileName(ResourceID var1, @RpcTimeout Time var2);

    public CompletableFuture<Map<Long, Exception>> requestTotalResourceLimitExceptions(@RpcTimeout Time var1);

    public CompletableFuture<Map<Long, Tuple2<ResourceID, Exception>>> requestTaskManagerExceptions(@RpcTimeout Time var1);
}

