/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.resultpartitionmaster;

import org.apache.flink.api.common.JobID;

public class RegisteredJobStatus {
    private JobID jobId;
    private boolean online;
    private long offlineTimestamp;

    public RegisteredJobStatus(JobID jobId) {
        this.jobId = jobId;
        this.online = true;
    }

    public void markOffline() {
        if (this.online) {
            this.online = false;
            this.offlineTimestamp = System.currentTimeMillis();
        }
    }

    public void markOnline() {
        if (!this.online) {
            this.online = true;
            this.offlineTimestamp = 0L;
        }
    }

    public boolean isTimeout(long timeoutInMills) {
        if (!this.online) {
            long now = System.currentTimeMillis();
            return now - this.offlineTimestamp > timeoutInMills;
        }
        return false;
    }

    public JobID getJobId() {
        return this.jobId;
    }
}

