/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.clusterframework.types.TaskManagerSlot;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.resourcemanager.SlotRequest;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingSlotRequest;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAssigningSlotManager
extends SlotManager {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicAssigningSlotManager.class);
    private final Map<ResourceID, Tuple2<Map<SlotID, ResourceProfile>, ResourceProfile>> allocatedSlotsResource = new HashMap<ResourceID, Tuple2<Map<SlotID, ResourceProfile>, ResourceProfile>>();
    private ResourceProfile totalResourceOfTaskExecutor;
    private SlotPlacementPolicy slotPlacementPolicy;
    private Comparator<TaskManagerSlot> slotComparator;

    public DynamicAssigningSlotManager(ScheduledExecutor scheduledExecutor, Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout, Time taskManagerCheckerInitialDelay) {
        this(scheduledExecutor, taskManagerRequestTimeout, slotRequestTimeout, taskManagerTimeout, taskManagerCheckerInitialDelay, SlotPlacementPolicy.RANDOM);
    }

    public DynamicAssigningSlotManager(ScheduledExecutor scheduledExecutor, Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout, Time taskManagerCheckerInitialDelay, SlotPlacementPolicy slotPlacementPolicy) {
        super(scheduledExecutor, taskManagerRequestTimeout, slotRequestTimeout, taskManagerTimeout, taskManagerCheckerInitialDelay);
        this.slotPlacementPolicy = slotPlacementPolicy;
        switch (slotPlacementPolicy) {
            case SLOT: {
                this.slotComparator = new Comparator<TaskManagerSlot>(){

                    @Override
                    public int compare(TaskManagerSlot o1, TaskManagerSlot o2) {
                        ResourceID rid1 = o1.getSlotId().getResourceID();
                        ResourceID rid2 = o2.getSlotId().getResourceID();
                        Tuple2 t1 = (Tuple2)DynamicAssigningSlotManager.this.allocatedSlotsResource.get(rid1);
                        Tuple2 t2 = (Tuple2)DynamicAssigningSlotManager.this.allocatedSlotsResource.get(rid2);
                        return (t1 == null ? 0 : ((Map)t1.f0).size()) - (t2 == null ? 0 : ((Map)t2.f0).size());
                    }
                };
                break;
            }
            case RESOURCE: {
                this.slotComparator = new Comparator<TaskManagerSlot>(){

                    @Override
                    public int compare(TaskManagerSlot o1, TaskManagerSlot o2) {
                        ResourceID rid1 = o1.getSlotId().getResourceID();
                        ResourceID rid2 = o2.getSlotId().getResourceID();
                        Tuple2 t1 = (Tuple2)DynamicAssigningSlotManager.this.allocatedSlotsResource.get(rid1);
                        Tuple2 t2 = (Tuple2)DynamicAssigningSlotManager.this.allocatedSlotsResource.get(rid2);
                        if (t1 != null && t2 != null) {
                            return ((ResourceProfile)t2.f1).compareTo((ResourceProfile)t1.f1);
                        }
                        if (t1 == null && t2 == null) {
                            return 0;
                        }
                        return t1 == null ? -1 : 1;
                    }
                };
                break;
            }
            default: {
                this.slotComparator = null;
            }
        }
        this.setSlotListener(new SlotListenerImpl());
    }

    @Override
    protected TaskManagerSlot findMatchingSlot(SlotRequest slotRequest) {
        if (this.slotPlacementPolicy == SlotPlacementPolicy.RANDOM) {
            return this.findMatchingSlotRandomly(slotRequest);
        }
        return this.findMatchingSlotSpreading(slotRequest);
    }

    protected TaskManagerSlot findMatchingSlotRandomly(SlotRequest slotRequest) {
        TaskManagerSlot slot;
        Random random = new Random();
        ArrayList resourceSlots = new ArrayList(this.freeSlots.values());
        int count = 0;
        while (count++ < this.freeSlots.size() / 2) {
            int index = random.nextInt(this.freeSlots.size());
            slot = (TaskManagerSlot)resourceSlots.get(index);
            if (!this.hasEnoughResource(slot.getSlotId().getResourceID(), slotRequest.getResourceProfile()) || !this.placementConstraintManager.check(slotRequest.getJobId(), (List)this.allocationIdTags.get((Object)slotRequest.getAllocationId()), this.getTaskExecutorSlotTags(slot.getSlotId()))) continue;
            this.recordAllocatedSlotAndResource(slot.getSlotId(), slotRequest.getResourceProfile());
            this.freeSlots.remove(slot.getSlotId());
            return slot;
        }
        Iterator iterator = this.freeSlots.entrySet().iterator();
        while (iterator.hasNext()) {
            slot = (TaskManagerSlot)iterator.next().getValue();
            if (!this.hasEnoughResource(slot.getSlotId().getResourceID(), slotRequest.getResourceProfile()) || !this.placementConstraintManager.check(slotRequest.getJobId(), (List)this.allocationIdTags.get((Object)slotRequest.getAllocationId()), this.getTaskExecutorSlotTags(slot.getSlotId()))) continue;
            this.recordAllocatedSlotAndResource(slot.getSlotId(), slotRequest.getResourceProfile());
            this.freeSlots.remove(slot.getSlotId());
            return slot;
        }
        return null;
    }

    protected TaskManagerSlot findMatchingSlotSpreading(SlotRequest slotRequest) {
        ArrayList slots = new ArrayList(this.freeSlots.values());
        Collections.sort(slots, (Comparator)Preconditions.checkNotNull(this.slotComparator));
        for (TaskManagerSlot slot : slots) {
            if (!this.hasEnoughResource(slot.getSlotId().getResourceID(), slotRequest.getResourceProfile()) || !this.placementConstraintManager.check(slotRequest.getJobId(), (List)this.allocationIdTags.get((Object)slotRequest.getAllocationId()), this.getTaskExecutorSlotTags(slot.getSlotId()))) continue;
            this.recordAllocatedSlotAndResource(slot.getSlotId(), slotRequest.getResourceProfile());
            this.freeSlots.remove(slot.getSlotId());
            return slot;
        }
        return null;
    }

    @Override
    protected PendingSlotRequest findMatchingRequest(TaskManagerSlot taskManagerSlot) {
        for (PendingSlotRequest pendingSlotRequest : this.pendingSlotRequests.values()) {
            if (pendingSlotRequest.isAssigned() || !this.hasEnoughResource(taskManagerSlot.getSlotId().getResourceID(), pendingSlotRequest.getResourceProfile()) || !this.placementConstraintManager.check(pendingSlotRequest.getJobId(), (List)this.allocationIdTags.get((Object)pendingSlotRequest.getAllocationId()), this.getTaskExecutorSlotTags(taskManagerSlot.getSlotId()))) continue;
            this.recordAllocatedSlotAndResource(taskManagerSlot.getSlotId(), pendingSlotRequest.getResourceProfile());
            return pendingSlotRequest;
        }
        return null;
    }

    @Override
    public ResourceProfile getTotalResource() {
        return this.totalResourceOfTaskExecutor.multiply(this.taskManagerRegistrations.size());
    }

    @Override
    public ResourceProfile getAvailableResource() {
        ResourceProfile availableResource = new ResourceProfile(0.0, 0);
        for (Tuple2<Map<SlotID, ResourceProfile>, ResourceProfile> allocated : this.allocatedSlotsResource.values()) {
            availableResource.addTo((ResourceProfile)allocated.f1);
        }
        int emptyTaskManagerNum = this.taskManagerRegistrations.size() - this.allocatedSlotsResource.size();
        availableResource.addTo(this.totalResourceOfTaskExecutor.multiply(emptyTaskManagerNum));
        return availableResource;
    }

    @Override
    public ResourceProfile getTotalResourceOf(ResourceID resourceID) {
        return this.totalResourceOfTaskExecutor;
    }

    @Override
    public ResourceProfile getAvailableResourceOf(ResourceID resourceID) {
        if (this.allocatedSlotsResource.containsKey(resourceID)) {
            return (ResourceProfile)this.allocatedSlotsResource.get((Object)resourceID).f1;
        }
        return this.totalResourceOfTaskExecutor;
    }

    public void setTotalResourceOfTaskExecutor(ResourceProfile resourceOfTaskExecutor) {
        this.totalResourceOfTaskExecutor = resourceOfTaskExecutor;
    }

    private void recordAllocatedSlotAndResource(SlotID slotID, ResourceProfile resourceProfile) {
        Tuple2 slotToResource;
        if (resourceProfile.equals(ResourceProfile.UNKNOWN)) {
            resourceProfile = new ResourceProfile(ResourceProfile.EMTPY);
        }
        if ((slotToResource = this.allocatedSlotsResource.get(slotID.getResourceID())) != null) {
            ((Map)slotToResource.f0).put(slotID, resourceProfile);
            slotToResource.f1 = ((ResourceProfile)slotToResource.f1).minus(resourceProfile);
        } else {
            HashMap<SlotID, ResourceProfile> allocated = new HashMap<SlotID, ResourceProfile>();
            allocated.put(slotID, resourceProfile);
            slotToResource = new Tuple2(allocated, (Object)this.totalResourceOfTaskExecutor.minus(resourceProfile));
            this.allocatedSlotsResource.put(slotID.getResourceID(), (Tuple2<Map<SlotID, ResourceProfile>, ResourceProfile>)slotToResource);
        }
    }

    private boolean hasEnoughResource(ResourceID taskManagerId, ResourceProfile required) {
        Tuple2<Map<SlotID, ResourceProfile>, ResourceProfile> allocatedResources = this.allocatedSlotsResource.get(taskManagerId);
        ResourceProfile remain = allocatedResources == null ? this.totalResourceOfTaskExecutor : (ResourceProfile)allocatedResources.f1;
        boolean isMatched = remain.isMatching(required);
        if (isMatched && LOG.isDebugEnabled()) {
            LOG.debug("Find matched resource in task manager id {} with remaining resource {} for required resource {}.The allocated slot resources are {} and all the slots are {}.", new Object[]{taskManagerId, remain, required, allocatedResources, this.slots});
        }
        return isMatched;
    }

    private void removeSlotFromAllocatedResources(SlotID slotId) {
        if (this.allocatedSlotsResource.containsKey(slotId.getResourceID())) {
            Tuple2<Map<SlotID, ResourceProfile>, ResourceProfile> slotToResource = this.allocatedSlotsResource.get(slotId.getResourceID());
            ResourceProfile rf = (ResourceProfile)((Map)slotToResource.f0).remove(slotId);
            if (rf != null) {
                slotToResource.f1 = ((ResourceProfile)slotToResource.f1).merge(rf);
            }
            if (((Map)slotToResource.f0).isEmpty()) {
                this.allocatedSlotsResource.remove(slotId.getResourceID());
            }
        }
    }

    @VisibleForTesting
    public Map<ResourceID, Tuple2<Map<SlotID, ResourceProfile>, ResourceProfile>> getAllocatedSlotsResource() {
        return this.allocatedSlotsResource;
    }

    public static enum SlotPlacementPolicy {
        RANDOM,
        SLOT,
        RESOURCE;

    }

    private class SlotListenerImpl
    implements SlotManager.SlotListener {
        private SlotListenerImpl() {
        }

        @Override
        public void notifySlotRegistered(SlotID slotId, ResourceProfile allocationResourceProfile) {
            DynamicAssigningSlotManager.this.recordAllocatedSlotAndResource(slotId, allocationResourceProfile);
        }

        @Override
        public void notifySlotFree(SlotID slotId) {
            DynamicAssigningSlotManager.this.removeSlotFromAllocatedResources(slotId);
        }

        @Override
        public void notifySlotRemoved(SlotID slotId) {
            DynamicAssigningSlotManager.this.removeSlotFromAllocatedResources(slotId);
        }
    }
}

