/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.clusterframework.types.TaskManagerSlot;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.resourcemanager.SlotRequest;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingSlotRequest;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.util.Preconditions;

public class StrictlyMatchingSlotManager
extends SlotManager {
    private Map<ResourceID, Set<SlotTag>> tmTags = new HashMap<ResourceID, Set<SlotTag>>();

    public StrictlyMatchingSlotManager(ScheduledExecutor scheduledExecutor, Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout, Time taskManagerCheckerInitialDelay) {
        this(scheduledExecutor, taskManagerRequestTimeout, slotRequestTimeout, taskManagerTimeout, Time.milliseconds((long)0L), taskManagerCheckerInitialDelay);
    }

    public StrictlyMatchingSlotManager(ScheduledExecutor scheduledExecutor, Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout, Time taskManagerFastTimeout, Time taskManagerCheckerInitialDelay) {
        super(scheduledExecutor, taskManagerRequestTimeout, slotRequestTimeout, taskManagerTimeout, taskManagerFastTimeout, taskManagerCheckerInitialDelay);
    }

    @Override
    protected TaskManagerSlot findMatchingSlot(SlotRequest slotRequest) {
        HashMap<ResourceID, Integer> numTmFreeSlots = new HashMap<ResourceID, Integer>();
        for (SlotID slotID : this.freeSlots.keySet()) {
            ResourceID resourceID = slotID.getResourceID();
            numTmFreeSlots.put(resourceID, numTmFreeSlots.getOrDefault(resourceID, 0) + 1);
        }
        Iterator iterator = this.freeSlots.entrySet().stream().sorted((entry1, entry2) -> {
            int comp = (Integer)numTmFreeSlots.get(((SlotID)entry1.getKey()).getResourceID()) - (Integer)numTmFreeSlots.get(((SlotID)entry2.getKey()).getResourceID());
            if (comp == 0) {
                comp = ((SlotID)entry1.getKey()).getResourceID().hashCode() - ((SlotID)entry2.getKey()).getResourceID().hashCode();
            }
            return comp;
        }).iterator();
        while (iterator.hasNext()) {
            TaskManagerSlot taskManagerSlot = (TaskManagerSlot)((Map.Entry)iterator.next()).getValue();
            Preconditions.checkState((taskManagerSlot.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0, (Object)String.format("Slot %s is in state %s", new Object[]{taskManagerSlot.getSlotId(), taskManagerSlot.getState()}));
            Set<SlotTag> tags = this.tmTags.get(taskManagerSlot.getSlotId().getResourceID());
            if (!taskManagerSlot.getResourceProfile().equals(slotRequest.getResourceProfile()) || tags != null && !tags.equals(slotRequest.getTags()) || !this.placementConstraintManager.check(slotRequest.getJobId(), (List)this.allocationIdTags.get((Object)slotRequest.getAllocationId()), this.getTaskExecutorSlotTags(taskManagerSlot.getSlotId()))) continue;
            this.freeSlots.remove(taskManagerSlot.getSlotId());
            return taskManagerSlot;
        }
        return null;
    }

    @Override
    protected PendingSlotRequest findMatchingRequest(TaskManagerSlot taskManagerSlot) {
        for (PendingSlotRequest pendingSlotRequest : this.pendingSlotRequests.values()) {
            Set<SlotTag> tags = this.tmTags.get(taskManagerSlot.getSlotId().getResourceID());
            if (!taskManagerSlot.getResourceProfile().equals(pendingSlotRequest.getResourceProfile()) || pendingSlotRequest.isAssigned() || tags != null && !tags.equals(new HashSet<SlotTag>(pendingSlotRequest.getTags())) || !this.placementConstraintManager.check(pendingSlotRequest.getJobId(), (List)this.allocationIdTags.get((Object)pendingSlotRequest.getAllocationId()), this.getTaskExecutorSlotTags(taskManagerSlot.getSlotId()))) continue;
            return pendingSlotRequest;
        }
        return null;
    }

    public void setTmTags(ResourceID resourceId, Set<SlotTag> tags) {
        this.tmTags.put(resourceId, tags);
    }
}

