/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.JobPendingSlotRequestsInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.JobPendingSlotRequestDetail;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;

public class JobPendingSlotRequestsHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, JobPendingSlotRequestsInfo, JobMessageParameters> {
    private final Time timeout;

    public JobPendingSlotRequestsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobPendingSlotRequestsInfo, JobMessageParameters> messageHeaders) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.timeout = timeout;
    }

    @Override
    protected CompletableFuture<JobPendingSlotRequestsInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, JobMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        CompletableFuture<JobStatus> jobStatusFuture = gateway.requestJobStatus(jobId, this.timeout);
        return ((CompletableFuture)jobStatusFuture.thenCompose(jobStatus -> {
            if (jobStatus == JobStatus.RUNNING) {
                return gateway.requestPendingSlotRequestDetails(jobId, this.timeout).thenApply(JobPendingSlotRequestsInfo::new);
            }
            return CompletableFuture.completedFuture(new JobPendingSlotRequestsInfo(new ArrayList<JobPendingSlotRequestDetail>()));
        })).exceptionally(throwable -> {
            Throwable cause = ExceptionUtils.stripCompletionException((Throwable)throwable);
            if (cause instanceof FlinkJobNotFoundException) {
                throw new CompletionException((Throwable)((Object)new RestHandlerException(throwable.getMessage(), HttpResponseStatus.NOT_FOUND, (Throwable)throwable)));
            }
            throw new CompletionException((Throwable)throwable);
        });
    }
}

