/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexDetailsInfo;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class JobVertexDetailsHandler
extends AbstractExecutionGraphHandler<JobVertexDetailsInfo, JobVertexMessageParameters>
implements JsonArchivist {
    private final MetricFetcher<? extends RestfulGateway> metricFetcher;
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;
    private final Time timeout;

    public JobVertexDetailsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobVertexDetailsInfo, JobVertexMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, MetricFetcher<? extends RestfulGateway> metricFetcher, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
        this.metricFetcher = metricFetcher;
        this.resourceManagerGatewayRetriever = (GatewayRetriever)Preconditions.checkNotNull(resourceManagerGatewayRetriever);
        this.timeout = timeout;
    }

    @Override
    protected JobVertexDetailsInfo handleRequest(HandlerRequest<EmptyRequestBody, JobVertexMessageParameters> request, AccessExecutionGraph executionGraph) throws RestHandlerException {
        JobID jobID = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID jobVertexID = (JobVertexID)((Object)request.getPathParameter(JobVertexIdPathParameter.class));
        AccessExecutionJobVertex jobVertex = executionGraph.getJobVertex(jobVertexID);
        if (jobVertex == null) {
            throw new NotFoundException(String.format("JobVertex %s not found", new Object[]{jobVertexID}));
        }
        return this.createJobVertexDetailsInfo(jobVertex, jobID, this.metricFetcher, this.resourceManagerGatewayRetriever, this.timeout);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        Collection<? extends AccessExecutionJobVertex> vertices = graph.getAllVertices().values();
        ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>(vertices.size());
        for (AccessExecutionJobVertex accessExecutionJobVertex : vertices) {
            JobVertexDetailsInfo json = this.createJobVertexDetailsInfo(accessExecutionJobVertex, graph.getJobID(), this.metricFetcher, this.resourceManagerGatewayRetriever, this.timeout);
            String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString());
            archive.add(new ArchivedJson(path, json));
        }
        return archive;
    }

    private JobVertexDetailsInfo createJobVertexDetailsInfo(AccessExecutionJobVertex jobVertex, JobID jobID, @Nullable MetricFetcher<?> metricFetcher, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, Time timeout) {
        ResourceManagerGateway resourceManagerGateway = null;
        try {
            resourceManagerGateway = this.getResourceManagerGateway(resourceManagerGatewayRetriever);
        }
        catch (RestHandlerException restHandlerException) {
            // empty catch block
        }
        ArrayList<JobVertexDetailsInfo.VertexTaskDetail> subtasks = new ArrayList<JobVertexDetailsInfo.VertexTaskDetail>();
        long now = System.currentTimeMillis();
        int num = 0;
        Tuple2<String, String> preLogAndStoutFileName = null;
        for (AccessExecutionVertex vertex : jobVertex.getTaskVertices()) {
            long endTime;
            ExecutionState status = vertex.getExecutionState();
            TaskManagerLocation location = vertex.getCurrentAssignedResourceLocation();
            String locationString = location == null ? "(unassigned)" : location.getHostname() + ":" + location.dataPort();
            long startTime = vertex.getStateTimestamp(ExecutionState.DEPLOYING);
            if (startTime == 0L) {
                startTime = -1L;
            }
            long l = endTime = status.isTerminal() ? vertex.getStateTimestamp(status) : -1L;
            long duration = startTime > 0L ? (endTime > 0L ? endTime : now) - startTime : -1L;
            MutableIOMetrics counts = new MutableIOMetrics();
            counts.addIOMetrics(vertex.getCurrentExecutionAttempt(), metricFetcher, jobID.toString(), jobVertex.getJobVertexId().toString());
            String resourceIdStr = "";
            String logfileName = "";
            String stdoutFileName = "";
            TaskManagerLocation taskManagerLocation = vertex.getCurrentAssignedResourceLocation();
            if (taskManagerLocation != null) {
                ResourceID resourceId = taskManagerLocation.getResourceID();
                resourceIdStr = resourceId.toString();
                Tuple2<String, String> logAndStoutFileName = this.getLogAndStoutFileName(resourceManagerGateway, resourceId, preLogAndStoutFileName);
                if (logAndStoutFileName != null) {
                    logfileName = (String)logAndStoutFileName.f0;
                    stdoutFileName = (String)logAndStoutFileName.f1;
                    preLogAndStoutFileName = logAndStoutFileName;
                }
            }
            subtasks.add(new JobVertexDetailsInfo.VertexTaskDetail(num, status, vertex.getCurrentExecutionAttempt().getAttemptNumber(), locationString, startTime, endTime, duration, new IOMetricsInfo(counts), resourceIdStr, logfileName, stdoutFileName));
            ++num;
        }
        return new JobVertexDetailsInfo(jobVertex.getJobVertexId(), jobVertex.getName(), jobVertex.getParallelism(), now, subtasks);
    }

    private Tuple2<String, String> getLogAndStoutFileName(ResourceManagerGateway resourceManagerGateway, ResourceID resourceId, Tuple2<String, String> preLogAndStoutFileName) {
        if (preLogAndStoutFileName != null) {
            String logFileName = (String)preLogAndStoutFileName.f0;
            String stdoutFileName = (String)preLogAndStoutFileName.f1;
            if ("taskmanager.log".equals(logFileName) && "taskmanager.out".equals(stdoutFileName)) {
                return preLogAndStoutFileName;
            }
        }
        if (resourceManagerGateway != null) {
            try {
                this.log.info("job vertex detail get log file from ResourceManager Api.");
                Tuple2<String, String> logAndStoutFileName = resourceManagerGateway.requestTmLogAndStdoutFileName(resourceId, this.timeout).get(this.timeout.toMilliseconds(), this.timeout.getUnit());
                return logAndStoutFileName;
            }
            catch (Exception ignore) {
                this.log.error(ignore.getMessage());
            }
        }
        return null;
    }
}

