/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorDescriptor;
import org.apache.flink.runtime.jobgraph.OperatorEdgeDescriptor;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.JobVerticesInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class JobVerticesInfoHandler
extends AbstractExecutionGraphHandler<JobVerticesInfo, JobMessageParameters>
implements JsonArchivist {
    private final MetricFetcher<?> metricFetcher;

    public JobVerticesInfoHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobVerticesInfo, JobMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, MetricFetcher<?> metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
        this.metricFetcher = (MetricFetcher)Preconditions.checkNotNull(metricFetcher);
    }

    @Override
    protected JobVerticesInfo handleRequest(HandlerRequest<EmptyRequestBody, JobMessageParameters> request, AccessExecutionGraph executionGraph) throws RestHandlerException {
        return JobVerticesInfoHandler.createJobVerticesInfo(executionGraph, this.metricFetcher);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        JobVerticesInfo json = JobVerticesInfoHandler.createJobVerticesInfo(graph, this.metricFetcher);
        String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString());
        return Collections.singleton(new ArchivedJson(path, json));
    }

    private static JobVerticesInfo createJobVerticesInfo(AccessExecutionGraph executionGraph, @Nullable MetricFetcher<?> metricFetcher) {
        ArrayList<JobVerticesInfo.JobVertex> jobVertices = new ArrayList<JobVerticesInfo.JobVertex>(executionGraph.getAllVertices().size());
        ArrayList<JobVerticesInfo.JobOperator> jobOperators = new ArrayList<JobVerticesInfo.JobOperator>();
        metricFetcher.update();
        int topologyID = 0;
        for (AccessExecutionJobVertex accessExecutionJobVertex : executionGraph.getVerticesTopologically()) {
            JobVerticesInfo.JobVertex jobVertex = JobVerticesInfoHandler.createJobVertex(accessExecutionJobVertex, executionGraph.getJobID(), topologyID, metricFetcher, jobOperators);
            jobVertices.add(jobVertex);
            ++topologyID;
        }
        return new JobVerticesInfo(jobVertices, jobOperators);
    }

    private static JobVerticesInfo.JobVertex createJobVertex(AccessExecutionJobVertex ejv, JobID jobId, int topologyId, MetricFetcher<?> metricFetcher, Collection<JobVerticesInfo.JobOperator> jobOperators) {
        ArrayList<Map<String, String>> subTaskMetrics = new ArrayList<Map<String, String>>();
        MutableIOMetrics counts = new MutableIOMetrics();
        for (AccessExecutionVertex vertex : ejv.getTaskVertices()) {
            MetricStore.ComponentMetricStore subTaskMetric = metricFetcher.getMetricStore().getSubtaskMetricStore(jobId.toString(), ejv.getJobVertexId().toString(), vertex.getCurrentExecutionAttempt().getParallelSubtaskIndex());
            counts.addIOMetrics(vertex.getCurrentExecutionAttempt(), metricFetcher, jobId.toString(), ejv.getJobVertexId().toString());
            if (subTaskMetric == null) break;
            subTaskMetrics.add(subTaskMetric.getMetrics());
        }
        for (OperatorDescriptor od : ejv.getOperatorDescriptors()) {
            JobVerticesInfo.JobOperator jobOperator = JobVerticesInfoHandler.createJobOperator(ejv.getJobVertexId(), od);
            jobOperators.add(jobOperator);
        }
        IOMetricsInfo jobVertexMetrics = new IOMetricsInfo(counts);
        return new JobVerticesInfo.JobVertex(ejv.getJobVertexId(), topologyId, ejv.getName(), ejv.getParallelism(), subTaskMetrics, jobVertexMetrics);
    }

    private static JobVerticesInfo.JobOperator createJobOperator(JobVertexID jobVertexID, OperatorDescriptor operatorDescriptor) {
        List<OperatorEdgeDescriptor> inputs = operatorDescriptor.getInputs();
        ArrayList<JobVerticesInfo.OperatorEdgeInfo> operatorEdfInfos = new ArrayList<JobVerticesInfo.OperatorEdgeInfo>(inputs.size());
        for (OperatorEdgeDescriptor oed : inputs) {
            operatorEdfInfos.add(new JobVerticesInfo.OperatorEdgeInfo(oed.getSourceOperator(), oed.getPartitionerDescriptor(), oed.getTypeNumber()));
        }
        return new JobVerticesInfo.JobOperator(jobVertexID, operatorDescriptor.getOperatorID(), operatorDescriptor.getOperatorName(), operatorEdfInfos, operatorDescriptor.getOperatorMetricsName());
    }
}

