/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.rescaling;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.JobUpdatingConfigStatus;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.UpdatingJobConfigRequest;
import org.apache.flink.runtime.update.JobUpdateRequest;
import org.apache.flink.runtime.update.action.JobConfigUpdateAction;
import org.apache.flink.runtime.update.action.JobUpdateAction;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;

public class JobUpdateJobConfigHandler
extends AbstractRestHandler<RestfulGateway, UpdatingJobConfigRequest, JobUpdatingConfigStatus, JobMessageParameters> {
    public JobUpdateJobConfigHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<UpdatingJobConfigRequest, JobUpdatingConfigStatus, JobMessageParameters> headers) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, headers);
    }

    @Override
    protected CompletableFuture<JobUpdatingConfigStatus> handleRequest(@Nonnull HandlerRequest<UpdatingJobConfigRequest, JobMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        JobID jobId;
        try {
            jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        }
        catch (Exception e) {
            throw new RestHandlerException("Failed to get JobID parameter.", HttpResponseStatus.BAD_REQUEST, e);
        }
        ArrayList<JobUpdateAction> actions = new ArrayList<JobUpdateAction>();
        Boolean triggerJobReload = false;
        try {
            Map<String, String> config = request.getRequestBody().getConfig();
            Configuration configuration = new Configuration();
            if (config != null && config.size() > 0) {
                this.log.info("updage job config [{}] jobId [{}]", (Object)config.toString(), (Object)jobId.toString());
                configuration.addAll(config);
                JobConfigUpdateAction jobConfigUpdateAction = new JobConfigUpdateAction(configuration);
                actions.add(jobConfigUpdateAction);
                if (null != request.getRequestBody().getJobReload()) {
                    triggerJobReload = request.getRequestBody().getJobReload();
                }
            }
        }
        catch (Exception e) {
            throw new RestHandlerException("Failed to deserialize update job config (jobId: " + jobId + ").", HttpResponseStatus.BAD_REQUEST, e);
        }
        if (actions.size() > 0) {
            JobUpdateRequest updateRequestrequest = new JobUpdateRequest(actions, triggerJobReload);
            return ((CompletableFuture)gateway.updateJob(jobId, updateRequestrequest, this.timeout).exceptionally(throwable -> {
                this.log.error("updage job config fail [{}]", (Object)jobId.toString());
                throw new CompletionException((Throwable)((Object)new RestHandlerException("Failed to update job (jobId: " + jobId + ").", HttpResponseStatus.INTERNAL_SERVER_ERROR, ExceptionUtils.stripCompletionException((Throwable)throwable))));
            })).thenApply(response -> {
                try {
                    this.log.info("updage job config success jobId [{}]", (Object)jobId.toString());
                    return new JobUpdatingConfigStatus(true);
                }
                catch (Exception e) {
                    this.log.error("updage job config success jobId [{}] error [{}]", (Object)jobId.toString(), (Object)e.getMessage());
                    throw new CompletionException((Throwable)((Object)new RestHandlerException("Failed to serialize JobUpdatingConfigStatus (jobId: " + jobId + ").", HttpResponseStatus.INTERNAL_SERVER_ERROR, e)));
                }
            });
        }
        return CompletableFuture.completedFuture(new JobUpdatingConfigStatus(false));
    }
}

