/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.rescaling;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.async.AbstractAsynchronousOperationHandlers;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationInfo;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingStatusMessageParameters;
import org.apache.flink.runtime.rest.handler.job.rescaling.UpdatingStatusHeaders;
import org.apache.flink.runtime.rest.handler.job.rescaling.UpdatingTriggerHeaders;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.runtime.rest.messages.TriggerIdPathParameter;
import org.apache.flink.runtime.rest.messages.job.UpdatingJobRequest;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.update.JobUpdateRequest;
import org.apache.flink.runtime.update.action.JobUpdateAction;
import org.apache.flink.runtime.update.action.JobVertexRescaleAction;
import org.apache.flink.runtime.update.action.JobVertexResourcesUpdateAction;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.SerializedThrowable;

public class UpdatingJobHandlers
extends AbstractAsynchronousOperationHandlers<AsynchronousJobOperationKey, Acknowledge> {

    public class UpdatingStatusHandler
    extends AbstractAsynchronousOperationHandlers.StatusHandler<RestfulGateway, AsynchronousOperationInfo, RescalingStatusMessageParameters> {
        public UpdatingStatusHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
            super(localRestAddress, leaderRetriever, timeout, responseHeaders, UpdatingStatusHeaders.getInstance());
        }

        @Override
        protected AsynchronousJobOperationKey getOperationKey(HandlerRequest<EmptyRequestBody, RescalingStatusMessageParameters> request) {
            JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
            TriggerId triggerId = (TriggerId)((Object)request.getPathParameter(TriggerIdPathParameter.class));
            return AsynchronousJobOperationKey.of(triggerId, jobId);
        }

        @Override
        protected AsynchronousOperationInfo exceptionalOperationResultResponse(Throwable throwable) {
            return AsynchronousOperationInfo.completeExceptional(new SerializedThrowable(throwable));
        }

        @Override
        protected AsynchronousOperationInfo operationResultResponse(Acknowledge operationResult) {
            return AsynchronousOperationInfo.complete();
        }
    }

    public class UpdatingTriggerHandler
    extends AbstractAsynchronousOperationHandlers.TriggerHandler<RestfulGateway, UpdatingJobRequest, JobMessageParameters> {
        private Time timeout;

        public UpdatingTriggerHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
            super(localRestAddress, leaderRetriever, timeout, responseHeaders, UpdatingTriggerHeaders.getInstance());
            this.timeout = timeout;
        }

        @Override
        protected CompletableFuture<Acknowledge> triggerOperation(HandlerRequest<UpdatingJobRequest, JobMessageParameters> request, RestfulGateway gateway) throws RestHandlerException {
            JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
            Map<String, UpdatingJobRequest.VertexResource> vertexParallelismResources = request.getRequestBody().getVertexParallelismResource();
            ArrayList<JobUpdateAction> actions = new ArrayList<JobUpdateAction>();
            if (vertexParallelismResources != null && !vertexParallelismResources.isEmpty()) {
                for (Map.Entry<String, UpdatingJobRequest.VertexResource> vertexParallelismResource : vertexParallelismResources.entrySet()) {
                    JobVertexID jobVertexID = JobVertexID.fromHexString(vertexParallelismResource.getKey());
                    UpdatingJobRequest.VertexResource vertexResource = vertexParallelismResource.getValue();
                    ResourceSpec newResourceSpec = vertexResource.getResource().convertToResourceSpec();
                    int parallelism = vertexResource.getParallelism();
                    actions.add(new JobVertexResourcesUpdateAction(jobVertexID, newResourceSpec));
                    actions.add(new JobVertexRescaleAction(jobVertexID, parallelism));
                }
            }
            JobUpdateRequest updateRequestrequest = new JobUpdateRequest(actions);
            CompletableFuture<Acknowledge> updatingFuture = gateway.updateJob(jobId, updateRequestrequest, RpcUtils.INF_TIMEOUT);
            return updatingFuture;
        }

        @Override
        protected AsynchronousJobOperationKey createOperationKey(HandlerRequest<UpdatingJobRequest, JobMessageParameters> request) {
            JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
            return AsynchronousJobOperationKey.of(new TriggerId(), jobId);
        }
    }
}

