/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJobVertexRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.util.FlinkException;

public abstract class AbstractSubtaskRequestHandler
extends AbstractJobVertexRequestHandler {
    public AbstractSubtaskRequestHandler(ExecutionGraphCache executionGraphHolder, Executor executor) {
        super(executionGraphHolder, executor);
    }

    @Override
    public final CompletableFuture<String> handleRequest(AccessExecutionJobVertex jobVertex, Map<String, String> params) {
        int subtask;
        String subtaskNumberString = params.get("subtasknum");
        if (subtaskNumberString == null) {
            return FutureUtils.completedExceptionally(new FlinkException("Subtask number parameter missing"));
        }
        try {
            subtask = Integer.parseInt(subtaskNumberString);
        }
        catch (NumberFormatException e) {
            return FutureUtils.completedExceptionally(new FlinkException("Invalid subtask number parameter", (Throwable)e));
        }
        if (subtask < 0 || subtask >= jobVertex.getParallelism()) {
            return FutureUtils.completedExceptionally(new FlinkException("subtask does not exist: " + subtask));
        }
        AccessExecutionVertex vertex = jobVertex.getTaskVertices()[subtask];
        return this.handleRequest(vertex, params);
    }

    public abstract CompletableFuture<String> handleRequest(AccessExecutionVertex var1, Map<String, String> var2);
}

