/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.util.Preconditions;

public class ExecutionGraphCache
implements Closeable {
    private final Time timeout;
    private final Time timeToLive;
    private final ConcurrentHashMap<JobID, ExecutionGraphEntry> cachedExecutionGraphs;
    private volatile boolean running = true;

    public ExecutionGraphCache(Time timeout, Time timeToLive) {
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.timeToLive = (Time)Preconditions.checkNotNull((Object)timeToLive);
        this.cachedExecutionGraphs = new ConcurrentHashMap(4);
    }

    @Override
    public void close() {
        this.running = false;
        this.cachedExecutionGraphs.clear();
    }

    public int size() {
        return this.cachedExecutionGraphs.size();
    }

    public List<JobID> getJobIds() {
        if (this.size() > 0) {
            return Collections.list(this.cachedExecutionGraphs.keys());
        }
        return new ArrayList<JobID>();
    }

    public CompletableFuture<AccessExecutionGraph> getExecutionGraph(JobID jobId, RestfulGateway restfulGateway) {
        ExecutionGraphEntry newEntry;
        boolean successfulUpdate;
        Preconditions.checkState((boolean)this.running, (Object)"ExecutionGraphCache is no longer running");
        do {
            long currentTime;
            ExecutionGraphEntry oldEntry;
            block9: {
                oldEntry = this.cachedExecutionGraphs.get(jobId);
                currentTime = System.currentTimeMillis();
                if (oldEntry != null && currentTime < oldEntry.getTTL()) {
                    CompletableFuture<AccessExecutionGraph> executionGraphFuture = oldEntry.getExecutionGraphFuture();
                    if (executionGraphFuture.isDone() && !executionGraphFuture.isCompletedExceptionally()) {
                        try {
                            AccessExecutionGraph executionGraph2 = executionGraphFuture.get();
                            if (executionGraph2.getState() != JobStatus.SUSPENDING && executionGraph2.getState() != JobStatus.SUSPENDED) {
                                return executionGraphFuture;
                            }
                            break block9;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException("Could not retrieve ExecutionGraph from the orderly completed future. This should never happen.", e);
                        }
                    }
                    if (!executionGraphFuture.isDone()) {
                        return executionGraphFuture;
                    }
                }
            }
            newEntry = new ExecutionGraphEntry(currentTime + this.timeToLive.toMilliseconds());
            if (oldEntry == null) {
                successfulUpdate = this.cachedExecutionGraphs.putIfAbsent(jobId, newEntry) == null;
                continue;
            }
            successfulUpdate = this.cachedExecutionGraphs.replace(jobId, oldEntry, newEntry);
            oldEntry.getExecutionGraphFuture().cancel(false);
        } while (!successfulUpdate);
        CompletableFuture<? extends AccessExecutionGraph> executionGraphFuture = restfulGateway.requestJob(jobId, this.timeout);
        executionGraphFuture.whenComplete((executionGraph, throwable) -> {
            if (throwable != null) {
                newEntry.getExecutionGraphFuture().completeExceptionally((Throwable)throwable);
                this.cachedExecutionGraphs.remove(jobId, newEntry);
            } else {
                newEntry.getExecutionGraphFuture().complete((AccessExecutionGraph)executionGraph);
                if (executionGraph.getState() == JobStatus.SUSPENDING || executionGraph.getState() == JobStatus.SUSPENDED) {
                    this.cachedExecutionGraphs.remove(jobId, newEntry);
                }
            }
        });
        if (!this.running) {
            this.cachedExecutionGraphs.remove(jobId, newEntry);
        }
        return newEntry.getExecutionGraphFuture();
    }

    public void cleanup() {
        long currentTime = System.currentTimeMillis();
        this.cachedExecutionGraphs.values().removeIf(entry -> currentTime >= entry.getTTL());
    }

    private static final class ExecutionGraphEntry {
        private final long ttl;
        private final CompletableFuture<AccessExecutionGraph> executionGraphFuture;

        ExecutionGraphEntry(long ttl) {
            this.ttl = ttl;
            this.executionGraphFuture = new CompletableFuture();
        }

        public long getTTL() {
            return this.ttl;
        }

        public CompletableFuture<AccessExecutionGraph> getExecutionGraphFuture() {
            return this.executionGraphFuture;
        }
    }
}

