/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.messages;

import java.util.Objects;
import org.apache.flink.runtime.instance.TaskManagerResourceDescription;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class ClusterOverviewWithVersion
extends ClusterOverview
implements ResponseBody {
    private static final long serialVersionUID = 5000058311783413216L;
    public static final String FIELD_NAME_VERSION = "flink-version";
    public static final String FIELD_NAME_COMMIT = "flink-commit";
    @JsonProperty(value="flink-version")
    private final String version;
    @JsonProperty(value="flink-commit")
    private final String commitId;

    @JsonCreator
    public ClusterOverviewWithVersion(@JsonProperty(value="taskmanagers") int numTaskManagersConnected, @JsonProperty(value="slots-total") int numSlotsTotal, @JsonProperty(value="slots-available") int numSlotsAvailable, @JsonProperty(value="total-resources") TaskManagerResourceDescription totalResources, @JsonProperty(value="available-resources") TaskManagerResourceDescription availableResources, @JsonProperty(value="jobs-running") int numJobsRunningOrPending, @JsonProperty(value="jobs-finished") int numJobsFinished, @JsonProperty(value="jobs-cancelled") int numJobsCancelled, @JsonProperty(value="jobs-failed") int numJobsFailed, @JsonProperty(value="flink-version") String version, @JsonProperty(value="flink-commit") String commitId) {
        super(numTaskManagersConnected, numSlotsTotal, numSlotsAvailable, totalResources, availableResources, numJobsRunningOrPending, numJobsFinished, numJobsCancelled, numJobsFailed);
        this.version = (String)Preconditions.checkNotNull((Object)version);
        this.commitId = (String)Preconditions.checkNotNull((Object)commitId);
    }

    public static ClusterOverviewWithVersion fromStatusOverview(ClusterOverview statusOverview, String version, String commitId) {
        return new ClusterOverviewWithVersion(statusOverview.getNumTaskManagersConnected(), statusOverview.getNumSlotsTotal(), statusOverview.getNumSlotsAvailable(), statusOverview.getTotalResources(), statusOverview.getAvailableResources(), statusOverview.getNumJobsRunningOrPending(), statusOverview.getNumJobsFinished(), statusOverview.getNumJobsCancelled(), statusOverview.getNumJobsFailed(), version, commitId);
    }

    public String getVersion() {
        return this.version;
    }

    public String getCommitId() {
        return this.commitId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterOverviewWithVersion that = (ClusterOverviewWithVersion)o;
        return Objects.equals(this.version, that.getVersion()) && Objects.equals(this.commitId, that.getCommitId());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.commitId != null ? this.commitId.hashCode() : 0);
        return result;
    }
}

