/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.rest.handler.legacy.metrics.AbstractAggregatingMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;

public class AggregatingJobsMetricsHandler
extends AbstractAggregatingMetricsHandler {
    public AggregatingJobsMetricsHandler(Executor executor, MetricFetcher fetcher) {
        super(executor, fetcher);
    }

    @Override
    protected Collection<? extends MetricStore.ComponentMetricStore> getStores(MetricStore store, Map<String, String> pathParameters, Map<String, String> queryParameters) {
        String jobsList = queryParameters.get("jobs");
        if (jobsList == null || jobsList.isEmpty()) {
            return store.getJobs().values();
        }
        String[] jobs = jobsList.split(",");
        ArrayList<MetricStore.ComponentMetricStore> jobStores = new ArrayList<MetricStore.ComponentMetricStore>();
        for (String job : jobs) {
            jobStores.add(store.getJobMetricStore(job));
        }
        return jobStores;
    }

    @Override
    public String[] getPaths() {
        return new String[]{"/jobs/metrics"};
    }
}

