/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerExceptionsInfos;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class TaskManagerExceptionsHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, TaskManagerExceptionsInfos, EmptyMessageParameters> {
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;

    public TaskManagerExceptionsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, TaskManagerExceptionsInfos, EmptyMessageParameters> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.resourceManagerGatewayRetriever = resourceManagerGatewayRetriever;
    }

    @Override
    protected CompletableFuture<TaskManagerExceptionsInfos> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, EmptyMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        ResourceManagerGateway resourceManagerGateway = this.getResourceManagerGateway(this.resourceManagerGatewayRetriever);
        return resourceManagerGateway.requestTaskManagerExceptions(this.timeout).thenApply(time2Exceptions -> {
            HashMap<Long, TaskManagerExceptionsInfos.TaskManagerException> taskmanagerExceptionsTmp = new HashMap<Long, TaskManagerExceptionsInfos.TaskManagerException>();
            if (null != time2Exceptions) {
                for (Map.Entry time2Exception : time2Exceptions.entrySet()) {
                    TaskManagerExceptionsInfos.TaskManagerException te = new TaskManagerExceptionsInfos.TaskManagerException((ResourceID)((Tuple2)time2Exception.getValue()).f0, (Exception)((Tuple2)time2Exception.getValue()).f1);
                    taskmanagerExceptionsTmp.put((Long)time2Exception.getKey(), te);
                }
            }
            return new TaskManagerExceptionsInfos(taskmanagerExceptionsTmp);
        });
    }
}

