/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.taskmanager.AbstractTaskManagerHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.JMXInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerIdPathParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class TaskManagerJMXHandler
extends AbstractTaskManagerHandler<RestfulGateway, EmptyRequestBody, JMXInfo, TaskManagerMessageParameters> {
    public TaskManagerJMXHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JMXInfo, TaskManagerMessageParameters> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, resourceManagerGatewayRetriever);
    }

    @Override
    protected CompletableFuture<JMXInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, TaskManagerMessageParameters> request, @Nonnull ResourceManagerGateway gateway) throws RestHandlerException {
        ResourceID resourceID = (ResourceID)request.getPathParameter(TaskManagerIdPathParameter.class);
        return this.getJmxPortFuture(resourceID, gateway).thenApply(jmxTuple -> new JMXInfo((String)jmxTuple.f0, (Long)jmxTuple.f1));
    }

    private CompletableFuture<Tuple2<String, Long>> getJmxPortFuture(ResourceID resourceID, ResourceManagerGateway gateway) {
        this.log.debug("get jmx information for resourceId:[{}].", (Object)resourceID.getResourceIdString());
        return gateway.requestJmx(resourceID, this.timeout);
    }
}

