/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.exceptions.UnknownTaskExecutorException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.taskmanager.AbstractTaskManagerHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.FileListsParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.FileNameQueryParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.LogInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.LogsInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerIdPathParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class TaskManagerLogsHandler
extends AbstractTaskManagerHandler<RestfulGateway, EmptyRequestBody, LogsInfo, FileListsParameters> {
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;

    public TaskManagerLogsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, LogsInfo, FileListsParameters> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, resourceManagerGatewayRetriever);
        this.resourceManagerGatewayRetriever = (GatewayRetriever)Preconditions.checkNotNull(resourceManagerGatewayRetriever);
    }

    @Override
    protected CompletableFuture<LogsInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, FileListsParameters> request, @Nonnull ResourceManagerGateway gateway) throws RestHandlerException {
        ResourceID taskManagerId = (ResourceID)request.getPathParameter(TaskManagerIdPathParameter.class);
        List fileNameTmpList = request.getQueryParameter(FileNameQueryParameter.class);
        String fileName = fileNameTmpList.isEmpty() ? null : (String)fileNameTmpList.get(0);
        ResourceManagerGateway resourceManagerGateway = this.getResourceManagerGateway(this.resourceManagerGatewayRetriever);
        CompletableFuture<Collection<Tuple2<String, Long>>> logsWithLengthFuture = resourceManagerGateway.requestTaskManagerLogList(taskManagerId, this.timeout);
        return ((CompletableFuture)logsWithLengthFuture.thenApply(logName2Sizes -> {
            if (null != logName2Sizes) {
                if (null == fileName) {
                    Collection logs = logName2Sizes.stream().map(logName2Size -> new LogInfo((String)logName2Size.f0, (Long)logName2Size.f1)).collect(Collectors.toSet());
                    return new LogsInfo(logs);
                }
                Optional<Tuple2> logOpt = logName2Sizes.stream().filter(l -> ((String)l.f0).equals(fileName)).findFirst();
                if (logOpt.isPresent()) {
                    Tuple2 log = logOpt.get();
                    ArrayList<LogInfo> logs = new ArrayList<LogInfo>();
                    logs.add(new LogInfo((String)log.f0, (Long)log.f1));
                    return new LogsInfo(logs);
                }
                return LogsInfo.empty();
            }
            return LogsInfo.empty();
        })).exceptionally(throwable -> {
            Throwable strippedThrowable = ExceptionUtils.stripExecutionException((Throwable)throwable);
            if (strippedThrowable instanceof UnknownTaskExecutorException) {
                throw new CompletionException((Throwable)((Object)new RestHandlerException("Could not find TaskExecutor " + taskManagerId + '.', HttpResponseStatus.NOT_FOUND, strippedThrowable)));
            }
            throw new CompletionException(strippedThrowable);
        });
    }
}

