/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.TaskManagerExecutionVertexCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerExecutionVertexIdsInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerIdPathParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class TaskmanagerAllSubtaskCurrentAttemptsHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, TaskManagerExecutionVertexIdsInfo, TaskManagerMessageParameters> {
    private TaskManagerExecutionVertexCache taskManagerExecutionVertexCache;
    private ExecutionGraphCache executionGraphCache;

    public TaskmanagerAllSubtaskCurrentAttemptsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, TaskManagerExecutionVertexIdsInfo, TaskManagerMessageParameters> messageHeaders, TaskManagerExecutionVertexCache taskManagerExecutionVertexCache, ExecutionGraphCache executionGraphCache) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.taskManagerExecutionVertexCache = taskManagerExecutionVertexCache;
        this.executionGraphCache = executionGraphCache;
    }

    @Override
    protected CompletableFuture<TaskManagerExecutionVertexIdsInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, TaskManagerMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        ResourceID taskManagerResourceId = (ResourceID)request.getPathParameter(TaskManagerIdPathParameter.class);
        try {
            CompletableFuture<TaskManagerExecutionVertexIdsInfo> r = new CompletableFuture<TaskManagerExecutionVertexIdsInfo>();
            r.complete(new TaskManagerExecutionVertexIdsInfo(this.taskManagerExecutionVertexCache.getTaskManagerExecutionVertex(taskManagerResourceId, gateway, this.executionGraphCache)));
            return r;
        }
        catch (Exception e) {
            return FutureUtils.completedExceptionally(e);
        }
    }
}

