/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.TaskManagerExecutionVertexCache;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerExecutionVertexIdsInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagersExecutionVertexIdsInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagersInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class TaskmanagersAllSubtaskCurrentAttemptsHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, TaskManagersExecutionVertexIdsInfo, EmptyMessageParameters> {
    private TaskManagerExecutionVertexCache taskManagerExecutionVertexCache;
    private ExecutionGraphCache executionGraphCache;
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;

    public TaskmanagersAllSubtaskCurrentAttemptsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, TaskManagersExecutionVertexIdsInfo, EmptyMessageParameters> messageHeaders, TaskManagerExecutionVertexCache taskManagerExecutionVertexCache, ExecutionGraphCache executionGraphCache, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.taskManagerExecutionVertexCache = taskManagerExecutionVertexCache;
        this.executionGraphCache = executionGraphCache;
        this.resourceManagerGatewayRetriever = (GatewayRetriever)Preconditions.checkNotNull(resourceManagerGatewayRetriever);
    }

    @Override
    protected CompletableFuture<TaskManagersExecutionVertexIdsInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, EmptyMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        try {
            HashMap<String, TaskManagerExecutionVertexIdsInfo> executionVertexIds;
            ResourceManagerGateway resourceManagerGateway = this.getResourceManagerGateway(this.resourceManagerGatewayRetriever);
            TaskManagersInfo ts = (TaskManagersInfo)((CompletableFuture)resourceManagerGateway.requestTaskManagerInfo(this.timeout).thenApply(TaskManagersInfo::new)).get();
            if (null != ts && ts.getTaskManagerInfos().size() > 0) {
                List tmIds = ts.getTaskManagerInfos().stream().map(TaskManagerInfo::getResourceId).collect(Collectors.toList());
                executionVertexIds = new HashMap(tmIds.size());
                for (ResourceID tmId : tmIds) {
                    TaskManagerExecutionVertexIdsInfo taskManagerExecutionVertexIdsInfo = new TaskManagerExecutionVertexIdsInfo(this.taskManagerExecutionVertexCache.getTaskManagerExecutionVertex(tmId, gateway, this.executionGraphCache));
                    executionVertexIds.put(tmId.getResourceIdString(), taskManagerExecutionVertexIdsInfo);
                }
            } else {
                executionVertexIds = new HashMap<String, TaskManagerExecutionVertexIdsInfo>();
            }
            CompletableFuture<TaskManagersExecutionVertexIdsInfo> r = new CompletableFuture<TaskManagersExecutionVertexIdsInfo>();
            r.complete(new TaskManagersExecutionVertexIdsInfo(executionVertexIds));
            return r;
        }
        catch (Exception e) {
            return FutureUtils.completedExceptionally(e);
        }
    }
}

