/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Objects;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class ExecutionVertexIDInfo
implements ResponseBody {
    public static final String FIELD_NAME_VERTEX_ID = "vertex-id";
    public static final String FIELD_NAME_TASK_INDEX = "task-index";
    @JsonProperty(value="vertex-id")
    @JsonSerialize(using=JobVertexIDSerializer.class)
    private final JobVertexID jobVertexID;
    @JsonProperty(value="task-index")
    private final int taskIndex;

    @JsonCreator
    public ExecutionVertexIDInfo(@JsonDeserialize(using=JobVertexIDDeserializer.class) @JsonProperty(value="vertex-id") JobVertexID jobVertexID, @JsonProperty(value="task-index") int taskIndex) {
        this.jobVertexID = jobVertexID;
        this.taskIndex = taskIndex;
    }

    @JsonIgnore
    public JobVertexID getJobVertexID() {
        return this.jobVertexID;
    }

    @JsonIgnore
    public int getTaskIndex() {
        return this.taskIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionVertexIDInfo that = (ExecutionVertexIDInfo)o;
        return Objects.equals((Object)this.jobVertexID, (Object)that.jobVertexID) && this.taskIndex == that.taskIndex;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobVertexID, this.taskIndex});
    }

    public ExecutionVertexID convertToResourceSpec() {
        return new ExecutionVertexID(this.jobVertexID, this.taskIndex);
    }
}

