/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.ResourceSpecInfo;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.json.AbstractIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.AbstractIDSerializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class JobGraphOverviewInfo
implements ResponseBody {
    public static final String FIELD_NAME_JOB_CONFIG = "config";
    public static final String FIELD_NAME_VERTEX_CONFIG = "vertex-config";
    public static final String FIELD_NAME_INPUT_NODES = "input-nodes";
    @JsonProperty(value="config")
    private final Map<String, String> config;
    @JsonProperty(value="vertex-config")
    private final Map<String, VertexConfigInfo> vertexConfigs;
    @JsonProperty(value="input-nodes")
    private final Map<String, List<EdgeConfigInfo>> inputNodes;

    @JsonCreator
    public JobGraphOverviewInfo(@JsonProperty(value="config") Map<String, String> config, @JsonProperty(value="vertex-config") Map<String, VertexConfigInfo> vertexConfigs, @JsonProperty(value="input-nodes") Map<String, List<EdgeConfigInfo>> inputNodes) {
        this.config = config;
        this.vertexConfigs = vertexConfigs;
        this.inputNodes = inputNodes;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public Map<String, VertexConfigInfo> getVertexConfigs() {
        return this.vertexConfigs;
    }

    public Map<String, List<EdgeConfigInfo>> getInputNodes() {
        return this.inputNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        JobGraphOverviewInfo that = (JobGraphOverviewInfo)o;
        return Objects.equals(this.config, that.config) && Objects.equals(this.vertexConfigs, that.vertexConfigs) && Objects.equals(this.inputNodes, that.inputNodes);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.vertexConfigs, this.inputNodes);
    }

    public static final class EdgeConfigInfo {
        public static final String FIELD_NAME_INPUT_VERTEX_ID = "input-vertex-id";
        public static final String FIELD_NAME_SHIP_STRATEGY_NAME = "ship-strategy-name";
        @JsonProperty(value="input-vertex-id")
        private final String inputVertexId;
        @JsonProperty(value="ship-strategy-name")
        private final String shipStrategyName;

        @JsonCreator
        public EdgeConfigInfo(@JsonProperty(value="input-vertex-id") String inputVertexId, @JsonProperty(value="ship-strategy-name") String shipStrategyName) {
            this.inputVertexId = inputVertexId;
            this.shipStrategyName = shipStrategyName;
        }

        @JsonIgnore
        public String getInputVertexId() {
            return this.inputVertexId;
        }

        @JsonIgnore
        public String getShipStrategyName() {
            return this.shipStrategyName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            EdgeConfigInfo that = (EdgeConfigInfo)o;
            return Objects.equals(this.inputVertexId, that.inputVertexId) && Objects.equals(this.shipStrategyName, that.shipStrategyName);
        }

        public int hashCode() {
            return Objects.hash(this.inputVertexId, this.shipStrategyName);
        }
    }

    public static final class VertexConfigInfo {
        public static final String FIELD_NAME_VERTEX_ID = "id";
        public static final String FIELD_NAME_VERTEX_NAME = "name";
        public static final String FIELD_NAME_PARALLELISM = "parallelism";
        public static final String FIELD_NAME_MAX_PARALLELISM = "max-parallelism";
        public static final String FIELD_NAME_RESOURCE_SPEC = "resource-spec";
        public static final String FIELD_NAME_NODE_IDS = "nodeIds";
        public static final String FIELD_NAME_COLOCATION_GROUP_ID = "co-location_id";
        @JsonProperty(value="id")
        @JsonSerialize(using=JobVertexIDSerializer.class)
        private final JobVertexID id;
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="parallelism")
        private final int parallelism;
        @JsonProperty(value="max-parallelism")
        private final int maxParallelism;
        @JsonProperty(value="resource-spec")
        private final ResourceSpecInfo resourceSpec;
        @JsonProperty(value="nodeIds")
        private final List<Integer> nodeIds;
        @JsonProperty(value="co-location_id")
        @JsonSerialize(using=AbstractIDSerializer.class)
        private final AbstractID coLocationGroupId;

        @JsonCreator
        public VertexConfigInfo(@JsonDeserialize(using=JobVertexIDDeserializer.class) @JsonProperty(value="id") JobVertexID id, @JsonProperty(value="name") String name, @JsonProperty(value="parallelism") int parallelism, @JsonProperty(value="max-parallelism") int maxParallelism, @JsonProperty(value="resource-spec") ResourceSpecInfo resourceSpec, @JsonProperty(value="nodeIds") List<Integer> nodeIds, @JsonProperty(value="co-location_id") @JsonDeserialize(using=AbstractIDDeserializer.class) AbstractID coLocationGroupId) {
            this.id = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)id)));
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.parallelism = parallelism;
            this.maxParallelism = maxParallelism;
            this.resourceSpec = resourceSpec;
            this.nodeIds = nodeIds;
            this.coLocationGroupId = coLocationGroupId;
        }

        @JsonIgnore
        public JobVertexID getId() {
            return this.id;
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public int getParallelism() {
            return this.parallelism;
        }

        @JsonIgnore
        public int getMaxParallelism() {
            return this.maxParallelism;
        }

        @JsonIgnore
        public ResourceSpecInfo getResourceSpec() {
            return this.resourceSpec;
        }

        @JsonIgnore
        public List<Integer> getNodeIds() {
            return this.nodeIds;
        }

        @JsonIgnore
        public AbstractID getCoLocationGroupId() {
            return this.coLocationGroupId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            VertexConfigInfo that = (VertexConfigInfo)o;
            return Objects.equals((Object)this.id, (Object)that.id) && Objects.equals(this.name, that.name) && this.parallelism == that.parallelism && Objects.equals(this.resourceSpec, that.resourceSpec) && Objects.equals(this.nodeIds, that.nodeIds) && Objects.equals(this.coLocationGroupId, that.coLocationGroupId);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.name, this.parallelism, this.resourceSpec, this.nodeIds, this.coLocationGroupId});
        }
    }
}

