/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.checkpoints;

import java.util.Objects;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class TaskCheckpointStatistics
implements ResponseBody {
    public static final String FIELD_NAME_ID = "id";
    public static final String FIELD_NAME_CHECKPOINT_STATUS = "status";
    public static final String FIELD_NAME_LATEST_ACK_TIMESTAMP = "latest_ack_timestamp";
    public static final String FIELD_NAME_STATE_SIZE = "state_size";
    public static final String FIELD_NAME_FULL_STATE_SIZE = "full_state_size";
    public static final String FIELD_NAME_DURATION = "end_to_end_duration";
    public static final String FIELD_NAME_ALIGNMENT_BUFFERED = "alignment_buffered";
    public static final String FIELD_NAME_NUM_SUBTASKS = "num_subtasks";
    public static final String FIELD_NAME_NUM_ACK_SUBTASKS = "num_acknowledged_subtasks";
    @JsonProperty(value="id")
    private final long checkpointId;
    @JsonProperty(value="status")
    private final CheckpointStatsStatus checkpointStatus;
    @JsonProperty(value="latest_ack_timestamp")
    private final long latestAckTimestamp;
    @JsonProperty(value="state_size")
    private final long stateSize;
    @JsonProperty(value="full_state_size")
    private final long fullStateSize;
    @JsonProperty(value="end_to_end_duration")
    private final long duration;
    @JsonProperty(value="alignment_buffered")
    private final long alignmentBuffered;
    @JsonProperty(value="num_subtasks")
    private final int numSubtasks;
    @JsonProperty(value="num_acknowledged_subtasks")
    private final int numAckSubtasks;

    @JsonCreator
    public TaskCheckpointStatistics(@JsonProperty(value="id") long checkpointId, @JsonProperty(value="status") CheckpointStatsStatus checkpointStatus, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="full_state_size") long fullStateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks) {
        this.checkpointId = checkpointId;
        this.checkpointStatus = (CheckpointStatsStatus)((Object)Preconditions.checkNotNull((Object)((Object)checkpointStatus)));
        this.latestAckTimestamp = latestAckTimestamp;
        this.stateSize = stateSize;
        this.fullStateSize = fullStateSize;
        this.duration = duration;
        this.alignmentBuffered = alignmentBuffered;
        this.numSubtasks = numSubtasks;
        this.numAckSubtasks = numAckSubtasks;
    }

    public long getLatestAckTimestamp() {
        return this.latestAckTimestamp;
    }

    public long getStateSize() {
        return this.stateSize;
    }

    public long getFullStateSize() {
        return this.fullStateSize;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getAlignmentBuffered() {
        return this.alignmentBuffered;
    }

    public int getNumSubtasks() {
        return this.numSubtasks;
    }

    public int getNumAckSubtasks() {
        return this.numAckSubtasks;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public CheckpointStatsStatus getCheckpointStatus() {
        return this.checkpointStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskCheckpointStatistics that = (TaskCheckpointStatistics)o;
        return this.checkpointId == that.checkpointId && this.latestAckTimestamp == that.latestAckTimestamp && this.stateSize == that.stateSize && this.fullStateSize == that.fullStateSize && this.duration == that.duration && this.alignmentBuffered == that.alignmentBuffered && this.numSubtasks == that.numSubtasks && this.numAckSubtasks == that.numAckSubtasks && this.checkpointStatus == that.checkpointStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkpointId, this.checkpointStatus, this.latestAckTimestamp, this.stateSize, this.fullStateSize, this.duration, this.alignmentBuffered, this.numSubtasks, this.numAckSubtasks});
    }
}

