/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.resources.CommonExtendedResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.rest.messages.json.AbstractIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.AbstractIDSerializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDSerializer;
import org.apache.flink.runtime.rest.messages.json.SlotRequestIdDeserializer;
import org.apache.flink.runtime.rest.messages.json.SlotRequestIdSerializer;
import org.apache.flink.runtime.rest.messages.json.SlotSharingGroupIdDeserializer;
import org.apache.flink.runtime.rest.messages.json.SlotSharingGroupIdSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class JobPendingSlotRequestDetail
implements Serializable {
    private static final long serialVersionUID = -7278419733850920818L;
    public static final String FIELD_NAME_SLOT_REQUEST_ID = "id";
    public static final String FIELD_NAME_RESOURCE_PROFILE = "resource_profile";
    public static final String FIELD_NAME_START_TIME = "start_time";
    public static final String FIELD_NAME_SLOT_SHARING_GROUP_ID = "sharing_id";
    public static final String FIELD_NAME_COLOCATION_GROUP_ID = "co-location_id";
    public static final String FIELD_NAME_JOB_VERTEX_TASKS = "tasks";
    public static final String FIELD_NAME_RESOURCE_CPU_CORES = "cpu_cores";
    public static final String FIELD_NAME_RESOURCE_HEAP_MEMORY = "heap_memory";
    public static final String FIELD_NAME_RESOURCE_DIRECT_MEMORY = "direct_memory";
    public static final String FIELD_NAME_RESOURCE_NATIVE_MEMORY = "native_memory";
    public static final String FIELD_NAME_RESOURCE_NETWORK_MEMORY = "network_memory";
    public static final String FIELD_NAME_RESOURCE_MANAGED_MEMORY = "managed_memory";
    @JsonProperty(value="id")
    @JsonSerialize(using=SlotRequestIdSerializer.class)
    private final SlotRequestId slotRequestId;
    @JsonProperty(value="resource_profile")
    @JsonSerialize(using=ResourceProfileSerializer.class)
    private final ResourceProfile resourceProfile;
    @JsonProperty(value="start_time")
    private final long startTime;
    @JsonProperty(value="sharing_id")
    @JsonSerialize(using=SlotSharingGroupIdSerializer.class)
    private final SlotSharingGroupId slotSharingGroupId;
    @JsonProperty(value="co-location_id")
    @JsonSerialize(using=AbstractIDSerializer.class)
    private final AbstractID coLocationGroupId;
    @JsonProperty(value="tasks")
    private final Collection<VertexTaskInfo> vertexTaskInfos;

    @JsonCreator
    public JobPendingSlotRequestDetail(@JsonProperty(value="id") @JsonDeserialize(using=SlotRequestIdDeserializer.class) SlotRequestId slotRequestId, @JsonProperty(value="resource_profile") @JsonDeserialize(using=ResourceProfileDeserializer.class) ResourceProfile resourceProfile, @JsonProperty(value="start_time") long startTime, @JsonProperty(value="sharing_id") @JsonDeserialize(using=SlotSharingGroupIdDeserializer.class) @Nullable SlotSharingGroupId slotSharingGroupId, @JsonProperty(value="co-location_id") @JsonDeserialize(using=AbstractIDDeserializer.class) @Nullable AbstractID coLocationGroupId, @JsonProperty(value="tasks") Collection<VertexTaskInfo> vertexTaskInfos) {
        this.slotRequestId = (SlotRequestId)((Object)Preconditions.checkNotNull((Object)((Object)slotRequestId)));
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
        this.startTime = startTime;
        this.slotSharingGroupId = slotSharingGroupId;
        this.coLocationGroupId = coLocationGroupId;
        this.vertexTaskInfos = (Collection)Preconditions.checkNotNull(vertexTaskInfos);
    }

    public SlotRequestId getSlotRequestId() {
        return this.slotRequestId;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public SlotSharingGroupId getSlotSharingGroupId() {
        return this.slotSharingGroupId;
    }

    public AbstractID getCoLocationGroupId() {
        return this.coLocationGroupId;
    }

    public Collection<VertexTaskInfo> getVertexTaskInfos() {
        return this.vertexTaskInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobPendingSlotRequestDetail that = (JobPendingSlotRequestDetail)o;
        return Objects.equals((Object)this.slotRequestId, (Object)that.slotRequestId) && Objects.equals(this.resourceProfile, that.resourceProfile) && this.startTime == that.startTime && Objects.equals((Object)this.slotSharingGroupId, (Object)that.slotSharingGroupId) && Objects.equals(this.coLocationGroupId, that.coLocationGroupId) && Objects.equals(this.vertexTaskInfos, that.vertexTaskInfos);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.slotRequestId, this.resourceProfile, this.startTime, this.slotSharingGroupId, this.coLocationGroupId, this.vertexTaskInfos});
    }

    public static final class ResourceProfileDeserializer
    extends StdDeserializer<ResourceProfile> {
        private static final long serialVersionUID = 1L;

        protected ResourceProfileDeserializer() {
            super(ResourceProfile.class);
        }

        public ResourceProfile deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode rootNode = (JsonNode)jsonParser.readValueAsTree();
            double cpuCores = rootNode.get(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_CPU_CORES).doubleValue();
            int heapMemoryInMB = ResourceProfileDeserializer.convertByteToMegabyte(rootNode.get(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_HEAP_MEMORY).longValue());
            int directMemoryInMB = ResourceProfileDeserializer.convertByteToMegabyte(rootNode.get(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_DIRECT_MEMORY).longValue());
            int nativeMemoryInMB = ResourceProfileDeserializer.convertByteToMegabyte(rootNode.get(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_NATIVE_MEMORY).longValue());
            int networkMemoryInMB = ResourceProfileDeserializer.convertByteToMegabyte(rootNode.get(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_NETWORK_MEMORY).longValue());
            int managedMemoryInMB = ResourceProfileDeserializer.convertByteToMegabyte(rootNode.get(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_MANAGED_MEMORY).longValue());
            HashMap<String, Resource> extendedResources = new HashMap<String, Resource>();
            if (managedMemoryInMB != 0) {
                extendedResources.put("MANAGED_MEMORY_MB", (Resource)new CommonExtendedResource("MANAGED_MEMORY_MB", (double)managedMemoryInMB));
            }
            return new ResourceProfile(cpuCores, heapMemoryInMB, directMemoryInMB, nativeMemoryInMB, networkMemoryInMB, extendedResources);
        }

        private static int convertByteToMegabyte(long value) {
            long result = value > 0L ? value / 0x100000L : value;
            return Long.valueOf(result).intValue();
        }
    }

    public static final class ResourceProfileSerializer
    extends StdSerializer<ResourceProfile> {
        private static final long serialVersionUID = 1L;

        protected ResourceProfileSerializer() {
            super(ResourceProfile.class);
        }

        public void serialize(ResourceProfile resourceProfile, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_CPU_CORES, resourceProfile.getCpuCores());
            jsonGenerator.writeNumberField(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_HEAP_MEMORY, ResourceProfileSerializer.convertMegabyteToByte(resourceProfile.getHeapMemoryInMB()));
            jsonGenerator.writeNumberField(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_DIRECT_MEMORY, ResourceProfileSerializer.convertMegabyteToByte(resourceProfile.getDirectMemoryInMB()));
            jsonGenerator.writeNumberField(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_NATIVE_MEMORY, ResourceProfileSerializer.convertMegabyteToByte(resourceProfile.getNativeMemoryInMB()));
            jsonGenerator.writeNumberField(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_NETWORK_MEMORY, ResourceProfileSerializer.convertMegabyteToByte(resourceProfile.getNetworkMemoryInMB()));
            jsonGenerator.writeNumberField(JobPendingSlotRequestDetail.FIELD_NAME_RESOURCE_MANAGED_MEMORY, ResourceProfileSerializer.convertMegabyteToByte(resourceProfile.getManagedMemoryInMB()));
            jsonGenerator.writeEndObject();
        }

        private static long convertMegabyteToByte(int value) {
            long result = value > 0 ? (long)(value * 1024 * 1024) : (long)value;
            return result;
        }
    }

    public static final class VertexTaskInfo
    implements Serializable {
        private static final long serialVersionUID = -3090688244400586852L;
        public static final String FIELD_NAME_VERTEX_ID = "vertex_id";
        public static final String FIELD_NAME_TASK_NAME = "task_name";
        public static final String FIELD_NAME_SUBTASK_INDEX = "subtask";
        public static final String FIELD_NAME_SUBTASK_ATTEMPT = "attempt";
        @JsonProperty(value="vertex_id")
        @JsonSerialize(using=JobVertexIDSerializer.class)
        private final JobVertexID vertexID;
        @JsonProperty(value="task_name")
        private final String taskName;
        @JsonProperty(value="subtask")
        private final int subtaskIndex;
        @JsonProperty(value="attempt")
        private final int subtaskAttempt;

        @JsonCreator
        public VertexTaskInfo(@JsonProperty(value="vertex_id") @JsonDeserialize(using=JobVertexIDDeserializer.class) JobVertexID vertexID, @JsonProperty(value="task_name") String taskName, @JsonProperty(value="subtask") int subtaskIndex, @JsonProperty(value="attempt") int subtaskAttempt) {
            this.vertexID = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)vertexID)));
            this.taskName = taskName;
            this.subtaskIndex = subtaskIndex;
            this.subtaskAttempt = subtaskAttempt;
        }

        public JobVertexID getVertexID() {
            return this.vertexID;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public int getSubtaskIndex() {
            return this.subtaskIndex;
        }

        public int getSubtaskAttempt() {
            return this.subtaskAttempt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            VertexTaskInfo that = (VertexTaskInfo)o;
            return Objects.equals((Object)this.vertexID, (Object)that.vertexID) && Objects.equals(this.taskName, that.taskName) && this.subtaskIndex == that.subtaskIndex && this.subtaskAttempt == that.subtaskAttempt;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.vertexID, this.taskName, this.subtaskIndex, this.subtaskAttempt});
        }
    }
}

