/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.util.Objects;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.json.ExecutionAttemptIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.ExecutionAttemptIDSerializer;
import org.apache.flink.runtime.rest.messages.json.ResourceIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.ResourceIDSerializer;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class SubtaskExecutionAttemptInfo
implements ResponseBody {
    public static final String FIELD_NAME_ID = "id";
    public static final String FIELD_NAME_STATUS = "status";
    public static final String FIELD_NAME_ATTEMPT = "attempt";
    public static final String FIELD_NAME_HOST = "host";
    public static final String FIELD_NAME_START_TIME = "start-time";
    public static final String FIELD_NAME_END_TIME = "end-time";
    public static final String FIELD_NAME_DURATION = "duration";
    public static final String FIELD_NAME_FAILURE_CAUSE = "failure-cause";
    public static final String FIELD_NAME_RESOURCE_ID = "resource-id";
    public static final String FIELD_NAME_SUBTASK_INDEX = "subtask-index";
    public static final String FIELD_NAME_VERTERX_ID = "vertex-id";
    public static final String FIELD_NAME_CURRENT_STATE_TIME = "current-start-time";
    @JsonProperty(value="id")
    @JsonSerialize(using=ExecutionAttemptIDSerializer.class)
    private final ExecutionAttemptID attemptID;
    @JsonProperty(value="status")
    private final ExecutionState status;
    @JsonProperty(value="attempt")
    private final int attempt;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="start-time")
    private final long startTime;
    @JsonProperty(value="end-time")
    private final long endTime;
    @JsonProperty(value="duration")
    private final long duration;
    @JsonProperty(value="failure-cause")
    private final String failureCause;
    @JsonProperty(value="resource-id")
    @JsonSerialize(using=ResourceIDSerializer.class)
    private final ResourceID resourceID;
    @JsonProperty(value="subtask-index")
    private final int subtaskIndex;
    @JsonProperty(value="vertex-id")
    private final String vertexId;
    @JsonProperty(value="current-start-time")
    private final long currentStateTime;

    @JsonCreator
    public SubtaskExecutionAttemptInfo(@JsonDeserialize(using=ExecutionAttemptIDDeserializer.class) @JsonProperty(value="id") ExecutionAttemptID attemptID, @JsonProperty(value="status") ExecutionState status, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="host") String host, @JsonProperty(value="start-time") long startTime, @JsonProperty(value="end-time") long endTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="failure-cause") String failureCause, @JsonDeserialize(using=ResourceIDDeserializer.class) @JsonProperty(value="resource-id") ResourceID resourceID, @JsonProperty(value="subtask-index") int subtaskIndex, @JsonProperty(value="vertex-id") String vertexId, @JsonProperty(value="current-start-time") long currentStateTime) {
        this.attemptID = (ExecutionAttemptID)((Object)Preconditions.checkNotNull((Object)((Object)attemptID)));
        this.status = (ExecutionState)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.attempt = attempt;
        this.host = (String)Preconditions.checkNotNull((Object)host);
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.failureCause = (String)Preconditions.checkNotNull((Object)failureCause);
        this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
        this.subtaskIndex = subtaskIndex;
        this.vertexId = vertexId;
        this.currentStateTime = currentStateTime;
    }

    public ExecutionAttemptID getAttemptID() {
        return this.attemptID;
    }

    public ExecutionState getStatus() {
        return this.status;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public String getHost() {
        return this.host;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getFailureCause() {
        return this.failureCause;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public String getVertexId() {
        return this.vertexId;
    }

    public long getCurrentStateTime() {
        return this.currentStateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtaskExecutionAttemptInfo that = (SubtaskExecutionAttemptInfo)o;
        return Objects.equals((Object)this.attemptID, (Object)that.attemptID) && this.status == that.status && this.attempt == that.attempt && Objects.equals(this.host, that.host) && this.startTime == that.startTime && this.endTime == that.endTime && this.duration == that.duration && Objects.equals(this.failureCause, that.failureCause) && Objects.equals(this.resourceID, that.resourceID) && this.subtaskIndex == that.subtaskIndex && Objects.equals(this.vertexId, that.vertexId) && this.currentStateTime == that.currentStateTime;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attemptID, this.status, this.attempt, this.host, this.startTime, this.endTime, this.duration, this.failureCause, this.resourceID, this.subtaskIndex, this.vertexId, this.currentStateTime});
    }

    public static SubtaskExecutionAttemptInfo create(AccessExecution execution, String vertexId) {
        long endTime;
        ExecutionState status = execution.getState();
        long now = System.currentTimeMillis();
        TaskManagerLocation location = execution.getAssignedResourceLocation();
        String locationString = location == null ? "(unassigned)" : location.getHostname() + ":" + location.dataPort();
        ResourceID resourceID = location == null ? new ResourceID("(unassigned)") : location.getResourceID();
        long startTime = execution.getStateTimestamp(ExecutionState.DEPLOYING);
        if (startTime == 0L) {
            startTime = -1L;
        }
        long l = endTime = status.isTerminal() ? execution.getStateTimestamp(status) : -1L;
        long duration = startTime > 0L ? (endTime > 0L ? endTime : now) - startTime : -1L;
        String failureCause = execution.getFailureCauseAsString();
        return new SubtaskExecutionAttemptInfo(execution.getAttemptId(), status, execution.getAttemptNumber(), locationString, startTime, endTime, duration, failureCause, resourceID, execution.getParallelSubtaskIndex(), vertexId, execution.getStateTimestamp(status));
    }
}

