/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.util.Collection;
import java.util.Objects;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.UserAccumulator;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class SubtasksAllAccumulatorsInfo
implements ResponseBody {
    public static final String FIELD_NAME_JOB_VERTEX_ID = "id";
    public static final String FIELD_NAME_PARALLELISM = "parallelism";
    public static final String FIELD_NAME_SUBTASKS = "subtasks";
    @JsonProperty(value="id")
    @JsonSerialize(using=JobVertexIDSerializer.class)
    private final JobVertexID jobVertexId;
    @JsonProperty(value="parallelism")
    private final int parallelism;
    @JsonProperty(value="subtasks")
    private final Collection<SubtaskAccumulatorsInfo> subtaskAccumulatorsInfos;

    @JsonCreator
    public SubtasksAllAccumulatorsInfo(@JsonDeserialize(using=JobVertexIDDeserializer.class) @JsonProperty(value="id") JobVertexID jobVertexId, @JsonProperty(value="parallelism") int parallelism, @JsonProperty(value="subtasks") Collection<SubtaskAccumulatorsInfo> subtaskAccumulatorsInfos) {
        this.jobVertexId = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexId)));
        this.parallelism = parallelism;
        this.subtaskAccumulatorsInfos = (Collection)Preconditions.checkNotNull(subtaskAccumulatorsInfos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtasksAllAccumulatorsInfo that = (SubtasksAllAccumulatorsInfo)o;
        return Objects.equals((Object)this.jobVertexId, (Object)that.jobVertexId) && this.parallelism == that.parallelism && Objects.equals(this.subtaskAccumulatorsInfos, that.subtaskAccumulatorsInfos);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobVertexId, this.parallelism, this.subtaskAccumulatorsInfos});
    }

    public static class SubtaskAccumulatorsInfo {
        public static final String FIELD_NAME_SUBTASK_INDEX = "subtask";
        public static final String FIELD_NAME_ATTEMPT_NUM = "attempt";
        public static final String FIELD_NAME_HOST = "host";
        public static final String FIELD_NAME_USER_ACCUMULATORS = "user-accumulators";
        @JsonProperty(value="subtask")
        private final int subtaskIndex;
        @JsonProperty(value="attempt")
        private final int attemptNum;
        @JsonProperty(value="host")
        private final String host;
        @JsonProperty(value="user-accumulators")
        private final Collection<UserAccumulator> userAccumulators;

        @JsonCreator
        public SubtaskAccumulatorsInfo(@JsonProperty(value="subtask") int subtaskIndex, @JsonProperty(value="attempt") int attemptNum, @JsonProperty(value="host") String host, @JsonProperty(value="user-accumulators") Collection<UserAccumulator> userAccumulators) {
            this.subtaskIndex = subtaskIndex;
            this.attemptNum = attemptNum;
            this.host = (String)Preconditions.checkNotNull((Object)host);
            this.userAccumulators = (Collection)Preconditions.checkNotNull(userAccumulators);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubtaskAccumulatorsInfo that = (SubtaskAccumulatorsInfo)o;
            return this.subtaskIndex == that.subtaskIndex && this.attemptNum == that.attemptNum && Objects.equals(this.host, that.host) && Objects.equals(this.userAccumulators, that.userAccumulators);
        }

        public int hashCode() {
            return Objects.hash(this.subtaskIndex, this.attemptNum, this.host, this.userAccumulators);
        }
    }
}

