/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job.metrics;

import java.util.Objects;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public final class IOMetricsInfo {
    private static final String FIELD_NAME_BYTES_READ = "read-bytes";
    private static final String FIELD_NAME_BYTES_READ_COMPLETE = "read-bytes-complete";
    private static final String FIELD_NAME_BYTES_WRITTEN = "write-bytes";
    private static final String FIELD_NAME_BYTES_WRITTEN_COMPLETE = "write-bytes-complete";
    private static final String FIELD_NAME_RECORDS_READ = "read-records";
    private static final String FIELD_NAME_RECORDS_READ_COMPLETE = "read-records-complete";
    private static final String FIELD_NAME_RECORDS_WRITTEN = "write-records";
    private static final String FIELD_NAME_RECORDS_WRITTEN_COMPLETE = "write-records-complete";
    private static final String FIELD_NAME_BUFFERS_IN_POOL_USAGE_MAX = "buffers-in-pool-usage-max";
    private static final String FIELD_NAME_BUFFERS_IN_POOL_USAGE_MAX_COMPLETE = "buffers-in-pool-usage-max-complete";
    private static final String FIELD_NAME_BUFFERS_OUT_POOL_USAGE_MAX = "buffers-out-pool-usage-max";
    private static final String FIELD_NAME_BUFFERS_OUT_POOL_USAGE_MAX_COMPLETE = "buffers-out-pool-usage-max-complete";
    private static final String FIELD_NAME_TPS = "tps";
    private static final String FIELD_NAME_TPS_COMPLETE = "tps-complete";
    private static final String FIELD_NAME_DELAY = "delay";
    private static final String FIELD_NAME_DELAY_COMPLETE = "delay-complete";
    @JsonProperty(value="read-bytes")
    private final long bytesRead;
    @JsonProperty(value="read-bytes-complete")
    private final boolean bytesReadComplete;
    @JsonProperty(value="write-bytes")
    private final long bytesWritten;
    @JsonProperty(value="write-bytes-complete")
    private final boolean bytesWrittenComplete;
    @JsonProperty(value="read-records")
    private final long recordsRead;
    @JsonProperty(value="read-records-complete")
    private final boolean recordsReadComplete;
    @JsonProperty(value="write-records")
    private final long recordsWritten;
    @JsonProperty(value="write-records-complete")
    private final boolean recordsWrittenComplete;
    @JsonProperty(value="buffers-in-pool-usage-max")
    private final float bufferInPoolUsageMax;
    @JsonProperty(value="buffers-in-pool-usage-max-complete")
    private final boolean bufferInPoolUsageMaxComplete;
    @JsonProperty(value="buffers-out-pool-usage-max")
    private final float bufferOutPoolUsageMax;
    @JsonProperty(value="buffers-out-pool-usage-max-complete")
    private final boolean bufferOutPoolUsageMaxComplete;
    @JsonProperty(value="tps")
    private final double tps;
    @JsonProperty(value="tps-complete")
    private final boolean tpsComplete;
    @JsonProperty(value="delay")
    private final long delay;
    @JsonProperty(value="delay-complete")
    private final boolean delayComplete;

    @JsonCreator
    public IOMetricsInfo(@JsonProperty(value="read-bytes") long bytesRead, @JsonProperty(value="read-bytes-complete") boolean bytesReadComplete, @JsonProperty(value="write-bytes") long bytesWritten, @JsonProperty(value="write-bytes-complete") boolean bytesWrittenComplete, @JsonProperty(value="read-records") long recordsRead, @JsonProperty(value="read-records-complete") boolean recordsReadComplete, @JsonProperty(value="write-records") long recordsWritten, @JsonProperty(value="write-records-complete") boolean recordsWrittenComplete, @JsonProperty(value="buffers-in-pool-usage-max") float bufferInPoolUsageMax, @JsonProperty(value="buffers-in-pool-usage-max-complete") boolean bufferInPoolUsageMaxComplete, @JsonProperty(value="buffers-out-pool-usage-max") float bufferOutPoolUsageMax, @JsonProperty(value="buffers-out-pool-usage-max-complete") boolean bufferOutPoolUsageMaxComplete, @JsonProperty(value="tps") double tps, @JsonProperty(value="tps-complete") boolean tpsComplete, @JsonProperty(value="delay") long delay, @JsonProperty(value="delay-complete") boolean delayComplete) {
        this.bytesRead = bytesRead;
        this.bytesReadComplete = bytesReadComplete;
        this.bytesWritten = bytesWritten;
        this.bytesWrittenComplete = bytesWrittenComplete;
        this.recordsRead = recordsRead;
        this.recordsReadComplete = recordsReadComplete;
        this.recordsWritten = recordsWritten;
        this.recordsWrittenComplete = recordsWrittenComplete;
        this.bufferInPoolUsageMax = bufferInPoolUsageMax;
        this.bufferInPoolUsageMaxComplete = bufferInPoolUsageMaxComplete;
        this.bufferOutPoolUsageMax = bufferOutPoolUsageMax;
        this.bufferOutPoolUsageMaxComplete = bufferOutPoolUsageMaxComplete;
        this.tps = tps;
        this.tpsComplete = tpsComplete;
        this.delay = delay;
        this.delayComplete = delayComplete;
    }

    public IOMetricsInfo(MutableIOMetrics counts) {
        this.bytesRead = counts.getNumBytesInLocal() + counts.getNumBytesInRemote();
        this.bytesReadComplete = counts.isNumBytesInLocalComplete() && counts.isNumBytesInRemoteComplete();
        this.bytesWritten = counts.getNumBytesOut();
        this.bytesWrittenComplete = counts.isNumBytesOutComplete();
        this.recordsRead = counts.getNumRecordsIn();
        this.recordsReadComplete = counts.isNumRecordsInComplete();
        this.recordsWritten = counts.getNumRecordsOut();
        this.recordsWrittenComplete = counts.isNumRecordsOutComplete();
        this.bufferInPoolUsageMax = counts.getBufferInPoolUsageMax();
        this.bufferInPoolUsageMaxComplete = counts.isBufferInPoolUsageMaxComplete();
        this.bufferOutPoolUsageMax = counts.getBufferOutPoolUsageMax();
        this.bufferOutPoolUsageMaxComplete = counts.isBufferOutPoolUsageMaxComplete();
        this.tps = counts.getTps();
        this.tpsComplete = counts.isTpsComplete();
        this.delay = counts.getDelay();
        this.delayComplete = counts.isDelayComplete();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public boolean isBytesReadComplete() {
        return this.bytesReadComplete;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean isBytesWrittenComplete() {
        return this.bytesWrittenComplete;
    }

    public long getRecordsRead() {
        return this.recordsRead;
    }

    public boolean isRecordsReadComplete() {
        return this.recordsReadComplete;
    }

    public long getRecordsWritten() {
        return this.recordsWritten;
    }

    public boolean isRecordsWrittenComplete() {
        return this.recordsWrittenComplete;
    }

    public float getBufferInPoolUsageMax() {
        return this.bufferInPoolUsageMax;
    }

    public boolean isBufferInPoolUsageMaxComplete() {
        return this.bufferInPoolUsageMaxComplete;
    }

    public float getBufferOutPoolUsageMax() {
        return this.bufferOutPoolUsageMax;
    }

    public boolean isBufferOutPoolUsageMaxComplete() {
        return this.bufferOutPoolUsageMaxComplete;
    }

    public double getTps() {
        return this.tps;
    }

    public boolean isTpsComplete() {
        return this.tpsComplete;
    }

    public long getDelay() {
        return this.delay;
    }

    public boolean isDelayComplete() {
        return this.delayComplete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOMetricsInfo that = (IOMetricsInfo)o;
        return this.bytesRead == that.bytesRead && this.bytesReadComplete == that.bytesReadComplete && this.bytesWritten == that.bytesWritten && this.bytesWrittenComplete == that.bytesWrittenComplete && this.recordsRead == that.recordsRead && this.recordsReadComplete == that.recordsReadComplete && this.recordsWritten == that.recordsWritten && this.recordsWrittenComplete == that.recordsWrittenComplete && this.bufferInPoolUsageMax == that.bufferInPoolUsageMax && this.bufferInPoolUsageMaxComplete == that.bufferInPoolUsageMaxComplete && this.bufferOutPoolUsageMax == that.bufferOutPoolUsageMax && this.bufferOutPoolUsageMaxComplete == that.bufferOutPoolUsageMaxComplete && this.tps == that.tps && this.tpsComplete == that.tpsComplete && this.delay == that.delay && this.delayComplete == that.delayComplete;
    }

    public int hashCode() {
        return Objects.hash(this.bytesRead, this.bytesReadComplete, this.bytesWritten, this.bytesWrittenComplete, this.recordsRead, this.recordsReadComplete, this.recordsWritten, this.recordsWrittenComplete, Float.valueOf(this.bufferInPoolUsageMax), this.bufferInPoolUsageMaxComplete, Float.valueOf(this.bufferOutPoolUsageMax), this.bufferOutPoolUsageMaxComplete, this.tps, this.tpsComplete, this.delay, this.delayComplete);
    }
}

