/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.taskmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class TaskManagerMetricsInfo {
    public static final String FIELD_NAME_HEAP_USED = "heapUsed";
    public static final String FIELD_NAME_HEAP_COMMITTED = "heapCommitted";
    public static final String FIELD_NAME_HEAP_MAX = "heapMax";
    public static final String FIELD_NAME_NON_HEAP_USED = "nonHeapUsed";
    public static final String FIELD_NAME_NON_HEAP_COMMITTED = "nonHeapCommitted";
    public static final String FIELD_NAME_NON_HEAP_MAX = "nonHeapMax";
    public static final String FIELD_NAME_DIRECT_COUNT = "directCount";
    public static final String FIELD_NAME_DIRECT_USED = "directUsed";
    public static final String FIELD_NAME_DIRECT_MAX = "directMax";
    public static final String FIELD_NAME_MAPPED_COUNT = "mappedCount";
    public static final String FIELD_NAME_MAPPED_USED = "mappedUsed";
    public static final String FIELD_NAME_MAPPED_MAX = "mappedMax";
    public static final String FIELD_NAME_NETWORK_MEMORY_SEGMENTS_AVAILABLE = "memorySegmentsAvailable";
    public static final String FIELD_NAME_NETWORK_MEMROY_SEGMENTS_TOTAL = "memorySegmentsTotal";
    public static final String FIELD_NAME_GARBAGE_COLLECTORS = "garbageCollectors";
    @JsonProperty(value="heapUsed")
    private final long heapUsed;
    @JsonProperty(value="heapCommitted")
    private final long heapCommitted;
    @JsonProperty(value="heapMax")
    private final long heapMax;
    @JsonProperty(value="nonHeapUsed")
    private final long nonHeapUsed;
    @JsonProperty(value="nonHeapCommitted")
    private final long nonHeapCommitted;
    @JsonProperty(value="nonHeapMax")
    private final long nonHeapMax;
    @JsonProperty(value="directCount")
    private final long directCount;
    @JsonProperty(value="directUsed")
    private final long directUsed;
    @JsonProperty(value="directMax")
    private final long directMax;
    @JsonProperty(value="mappedCount")
    private final long mappedCount;
    @JsonProperty(value="mappedUsed")
    private final long mappedUsed;
    @JsonProperty(value="mappedMax")
    private final long mappedMax;
    @JsonProperty(value="memorySegmentsAvailable")
    private final long memorySegmentsAvailable;
    @JsonProperty(value="memorySegmentsTotal")
    private final long memorySegmentsTotal;
    @JsonProperty(value="garbageCollectors")
    private final List<GarbageCollectorInfo> garbageCollectorsInfo;

    @JsonCreator
    public TaskManagerMetricsInfo(@JsonProperty(value="heapUsed") long heapUsed, @JsonProperty(value="heapCommitted") long heapCommitted, @JsonProperty(value="heapMax") long heapMax, @JsonProperty(value="nonHeapUsed") long nonHeapUsed, @JsonProperty(value="nonHeapCommitted") long nonHeapCommitted, @JsonProperty(value="nonHeapMax") long nonHeapMax, @JsonProperty(value="directCount") long directCount, @JsonProperty(value="directUsed") long directUsed, @JsonProperty(value="directMax") long directMax, @JsonProperty(value="mappedCount") long mappedCount, @JsonProperty(value="mappedUsed") long mappedUsed, @JsonProperty(value="mappedMax") long mappedMax, @JsonProperty(value="memorySegmentsAvailable") long memorySegmentsAvailable, @JsonProperty(value="memorySegmentsTotal") long memorySegmentsTotal, @JsonProperty(value="garbageCollectors") List<GarbageCollectorInfo> garbageCollectorsInfo) {
        this.heapUsed = heapUsed;
        this.heapCommitted = heapCommitted;
        this.heapMax = heapMax;
        this.nonHeapUsed = nonHeapUsed;
        this.nonHeapCommitted = nonHeapCommitted;
        this.nonHeapMax = nonHeapMax;
        this.directCount = directCount;
        this.directUsed = directUsed;
        this.directMax = directMax;
        this.mappedCount = mappedCount;
        this.mappedUsed = mappedUsed;
        this.mappedMax = mappedMax;
        this.memorySegmentsAvailable = memorySegmentsAvailable;
        this.memorySegmentsTotal = memorySegmentsTotal;
        this.garbageCollectorsInfo = (List)Preconditions.checkNotNull(garbageCollectorsInfo);
    }

    public TaskManagerMetricsInfo(MetricStore.TaskManagerMetricStore tmMetrics) {
        Preconditions.checkNotNull((Object)tmMetrics);
        long heapUsed = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.Heap.Used", "0"));
        long heapCommitted = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.Heap.Committed", "0"));
        long heapTotal = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.Heap.Max", "0"));
        long nonHeapUsed = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.NonHeap.Used", "0"));
        long nonHeapCommitted = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.NonHeap.Committed", "0"));
        long nonHeapTotal = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.NonHeap.Max", "0"));
        long directCount = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.Direct.Count", "0"));
        long directUsed = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.Direct.MemoryUsed", "0"));
        long directMax = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.Direct.TotalCapacity", "0"));
        long mappedCount = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.Mapped.Count", "0"));
        long mappedUsed = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.Mapped.MemoryUsed", "0"));
        long mappedMax = Long.valueOf(tmMetrics.getMetric("Status.JVM.Memory.Mapped.TotalCapacity", "0"));
        long memorySegmentsAvailable = Long.valueOf(tmMetrics.getMetric("Status.Network.AvailableMemorySegments", "0"));
        long memorySegmentsTotal = Long.valueOf(tmMetrics.getMetric("Status.Network.TotalMemorySegments", "0"));
        List<GarbageCollectorInfo> garbageCollectorInfo = TaskManagerMetricsInfo.createGarbageCollectorInfo(tmMetrics);
        this.heapUsed = heapUsed;
        this.heapCommitted = heapCommitted;
        this.heapMax = heapTotal;
        this.nonHeapUsed = nonHeapUsed;
        this.nonHeapCommitted = nonHeapCommitted;
        this.nonHeapMax = nonHeapTotal;
        this.directCount = directCount;
        this.directUsed = directUsed;
        this.directMax = directMax;
        this.mappedCount = mappedCount;
        this.mappedUsed = mappedUsed;
        this.mappedMax = mappedMax;
        this.memorySegmentsAvailable = memorySegmentsAvailable;
        this.memorySegmentsTotal = memorySegmentsTotal;
        this.garbageCollectorsInfo = (List)Preconditions.checkNotNull(garbageCollectorInfo);
    }

    private static List<GarbageCollectorInfo> createGarbageCollectorInfo(MetricStore.TaskManagerMetricStore taskManagerMetricStore) {
        Preconditions.checkNotNull((Object)taskManagerMetricStore);
        ArrayList<GarbageCollectorInfo> garbageCollectorInfos = new ArrayList<GarbageCollectorInfo>(taskManagerMetricStore.garbageCollectorNames.size());
        for (String garbageCollectorName : taskManagerMetricStore.garbageCollectorNames) {
            String count = taskManagerMetricStore.getMetric("Status.JVM.GarbageCollector." + garbageCollectorName + ".Count", null);
            String time = taskManagerMetricStore.getMetric("Status.JVM.GarbageCollector." + garbageCollectorName + ".Time", null);
            if (count == null || time == null) continue;
            garbageCollectorInfos.add(new GarbageCollectorInfo(garbageCollectorName, Long.valueOf(count), Long.valueOf(time)));
        }
        return garbageCollectorInfos;
    }

    @JsonIgnore
    public long getHeapUsed() {
        return this.heapUsed;
    }

    @JsonIgnore
    public long getHeapCommitted() {
        return this.heapCommitted;
    }

    public long getHeapMax() {
        return this.heapMax;
    }

    @JsonIgnore
    public long getNonHeapUsed() {
        return this.nonHeapUsed;
    }

    @JsonIgnore
    public long getNonHeapCommitted() {
        return this.nonHeapCommitted;
    }

    @JsonIgnore
    public long getNonHeapMax() {
        return this.nonHeapMax;
    }

    @JsonIgnore
    public long getDirectCount() {
        return this.directCount;
    }

    @JsonIgnore
    public long getDirectUsed() {
        return this.directUsed;
    }

    @JsonIgnore
    public long getDirectMax() {
        return this.directMax;
    }

    @JsonIgnore
    public long getMappedCount() {
        return this.mappedCount;
    }

    @JsonIgnore
    public long getMappedUsed() {
        return this.mappedUsed;
    }

    @JsonIgnore
    public long getMappedMax() {
        return this.mappedMax;
    }

    @JsonIgnore
    public long getMemorySegmentsAvailable() {
        return this.memorySegmentsAvailable;
    }

    @JsonIgnore
    public long getMemorySegmentsTotal() {
        return this.memorySegmentsTotal;
    }

    @JsonIgnore
    public List<GarbageCollectorInfo> getGarbageCollectorsInfo() {
        return this.garbageCollectorsInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskManagerMetricsInfo that = (TaskManagerMetricsInfo)o;
        return this.heapUsed == that.heapUsed && this.heapCommitted == that.heapCommitted && this.heapMax == that.heapMax && this.nonHeapUsed == that.nonHeapUsed && this.nonHeapCommitted == that.nonHeapCommitted && this.nonHeapMax == that.nonHeapMax && this.directCount == that.directCount && this.directUsed == that.directUsed && this.directMax == that.directMax && this.mappedCount == that.mappedCount && this.mappedUsed == that.mappedUsed && this.mappedMax == that.mappedMax && this.memorySegmentsAvailable == that.memorySegmentsAvailable && this.memorySegmentsTotal == that.memorySegmentsTotal && Objects.equals(this.garbageCollectorsInfo, that.garbageCollectorsInfo);
    }

    public int hashCode() {
        return Objects.hash(this.heapUsed, this.heapCommitted, this.heapMax, this.nonHeapUsed, this.nonHeapCommitted, this.nonHeapMax, this.directCount, this.directUsed, this.directMax, this.mappedCount, this.mappedUsed, this.mappedMax, this.memorySegmentsAvailable, this.memorySegmentsTotal, this.garbageCollectorsInfo);
    }

    public static TaskManagerMetricsInfo empty() {
        return new TaskManagerMetricsInfo(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, Collections.emptyList());
    }

    public static class GarbageCollectorInfo {
        public static final String FIELD_NAME_NAME = "name";
        public static final String FIELD_NAME_COUNT = "count";
        public static final String FIELD_NAME_TIME = "time";
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="count")
        private final long count;
        @JsonProperty(value="time")
        private final long time;

        @JsonCreator
        public GarbageCollectorInfo(@JsonProperty(value="name") String name, @JsonProperty(value="count") long count, @JsonProperty(value="time") long time) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.count = count;
            this.time = time;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GarbageCollectorInfo that = (GarbageCollectorInfo)o;
            return this.count == that.count && this.time == that.time && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.count, this.time);
        }
    }
}

