/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.schedule;

import java.util.Set;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.schedule.SlotSharingResourceCalculator;

public class SummationSlotSharingResourceCalculator
implements SlotSharingResourceCalculator {
    @Override
    public ResourceProfile calculateSharedGroupResource(SlotSharingGroup slotSharingGroup, ExecutionGraph executionGraph) {
        ResourceProfile shareGroupResource = null;
        Set<JobVertexID> jobVertexIDS = slotSharingGroup.getJobVertexIds();
        for (JobVertexID id : jobVertexIDS) {
            ExecutionVertex[] tasks = executionGraph.getJobVertex(id).getTaskVertices();
            ResourceProfile vertexMaxResource = null;
            for (ExecutionVertex task : tasks) {
                ResourceProfile taskResource = task.calculateResourceProfile();
                if (taskResource == ResourceProfile.UNKNOWN) {
                    return ResourceProfile.UNKNOWN;
                }
                if (vertexMaxResource == null) {
                    vertexMaxResource = taskResource;
                    continue;
                }
                if (!taskResource.isMatching(vertexMaxResource)) continue;
                vertexMaxResource = taskResource;
            }
            if (shareGroupResource == null) {
                shareGroupResource = vertexMaxResource;
                continue;
            }
            shareGroupResource = shareGroupResource.merge(vertexMaxResource);
        }
        return shareGroupResource;
    }
}

