/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.CheckpointListener;
import org.apache.flink.runtime.state.InternalStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.RegisteredStateMetaInfo;
import org.apache.flink.runtime.state.SnappyStreamCompressionDecorator;
import org.apache.flink.runtime.state.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.runtime.state.keyed.KeyedListState;
import org.apache.flink.runtime.state.keyed.KeyedListStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedListStateImpl;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedMapStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedMapStateImpl;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapState;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapStateImpl;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedStateBinder;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.runtime.state.keyed.KeyedValueStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedValueStateImpl;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListStateImpl;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapStateImpl;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapStateImpl;
import org.apache.flink.runtime.state.subkeyed.SubKeyedState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateBinder;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueStateImpl;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StateMigrationException;

public abstract class AbstractInternalStateBackend
implements InternalStateBackend,
Closeable,
KeyedStateBinder,
SubKeyedStateBinder,
CheckpointListener {
    private int numberOfGroups;
    private KeyGroupRange keyGroupRange;
    private ClassLoader userClassLoader;
    protected CloseableRegistry cancelStreamRegistry;
    protected TaskKvStateRegistry kvStateRegistry;
    protected final Map<String, StateMetaInfoSnapshot> restoredKvStateMetaInfos;
    protected final Map<String, StateStorage> stateStorages;
    protected final transient Map<String, KeyedState> keyedStates;
    protected final transient Map<String, SubKeyedState> subKeyedStates;
    protected final Map<String, RegisteredStateMetaInfo> registeredStateMetaInfos;
    protected final StreamCompressionDecorator keyGroupCompressionDecorator;

    protected void closeImpl() {
    }

    protected abstract StateStorage getOrCreateStateStorageForKeyedState(RegisteredStateMetaInfo var1);

    protected abstract StateStorage getOrCreateStateStorageForSubKeyedState(RegisteredStateMetaInfo var1);

    protected AbstractInternalStateBackend(int numberOfGroups, KeyGroupRange keyGroupRange, ClassLoader userClassLoader, TaskKvStateRegistry kvStateRegistry, ExecutionConfig executionConfig) {
        this.numberOfGroups = numberOfGroups;
        this.keyGroupRange = (KeyGroupRange)Preconditions.checkNotNull((Object)keyGroupRange);
        this.userClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userClassLoader);
        this.cancelStreamRegistry = new CloseableRegistry();
        this.kvStateRegistry = kvStateRegistry;
        this.restoredKvStateMetaInfos = new HashMap<String, StateMetaInfoSnapshot>();
        this.stateStorages = new HashMap<String, StateStorage>();
        this.keyedStates = new HashMap<String, KeyedState>();
        this.subKeyedStates = new HashMap<String, SubKeyedState>();
        this.registeredStateMetaInfos = new HashMap<String, RegisteredStateMetaInfo>();
        this.keyGroupCompressionDecorator = this.determineStreamCompression(executionConfig);
    }

    private StreamCompressionDecorator determineStreamCompression(ExecutionConfig executionConfig) {
        if (executionConfig != null && executionConfig.isUseSnapshotCompression()) {
            return SnappyStreamCompressionDecorator.INSTANCE;
        }
        return UncompressedStreamCompressionDecorator.INSTANCE;
    }

    @Override
    public int getNumGroups() {
        return this.numberOfGroups;
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    public Map<String, StateMetaInfoSnapshot> getRestoredKvStateMetaInfos() {
        return this.restoredKvStateMetaInfos;
    }

    @Override
    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    @Override
    public Map<String, KeyedState> getKeyedStates() {
        return this.keyedStates;
    }

    @Override
    public Map<String, SubKeyedState> getSubKeyedStates() {
        return this.subKeyedStates;
    }

    public Map<String, RegisteredStateMetaInfo> getRegisteredStateMetaInfos() {
        return this.registeredStateMetaInfos;
    }

    public TaskKvStateRegistry getKvStateRegistry() {
        return this.kvStateRegistry;
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }

    @VisibleForTesting
    public abstract int numStateEntries();

    @Override
    public void dispose() {
        this.closeImpl();
        IOUtils.closeQuietly((AutoCloseable)this.cancelStreamRegistry);
        this.keyedStates.clear();
        this.subKeyedStates.clear();
        this.registeredStateMetaInfos.clear();
        this.stateStorages.clear();
        this.restoredKvStateMetaInfos.clear();
    }

    @Override
    public void close() throws IOException {
        this.cancelStreamRegistry.close();
    }

    @Override
    public <K, V, S extends KeyedState<K, V>> S getKeyedState(KeyedStateDescriptor<K, V, S> keyedStateDescriptor) throws Exception {
        Preconditions.checkNotNull(keyedStateDescriptor);
        return keyedStateDescriptor.bind(this);
    }

    @Override
    public <K, N, V, S extends SubKeyedState<K, N, V>> S getSubKeyedState(SubKeyedStateDescriptor<K, N, V, S> stateDescriptor) throws Exception {
        Preconditions.checkNotNull(stateDescriptor);
        return stateDescriptor.bind(this);
    }

    @Override
    public <K, V> KeyedValueState<K, V> createKeyedValueState(KeyedValueStateDescriptor<K, V> keyedStateDescriptor) throws Exception {
        String stateName = keyedStateDescriptor.getName();
        KeyedValueStateImpl<K, V> keyedState = (KeyedValueStateImpl<K, V>)this.keyedStates.get(stateName);
        if (keyedState == null) {
            RegisteredStateMetaInfo newStateMetaInfo = this.tryRegisterStateMetaInfo(keyedStateDescriptor);
            StateStorage stateStorage = this.getOrCreateStateStorageForKeyedState(newStateMetaInfo);
            keyedState = new KeyedValueStateImpl<K, V>(this, keyedStateDescriptor, stateStorage);
            this.keyedStates.put(stateName, keyedState);
        }
        return keyedState;
    }

    @Override
    public <K, E> KeyedListState<K, E> createKeyedListState(KeyedListStateDescriptor<K, E> keyedStateDescriptor) throws Exception {
        String stateName = keyedStateDescriptor.getName();
        KeyedListStateImpl<K, E> keyedState = (KeyedListStateImpl<K, E>)this.keyedStates.get(stateName);
        if (keyedState == null) {
            RegisteredStateMetaInfo newStateMetaInfo = this.tryRegisterStateMetaInfo(keyedStateDescriptor);
            StateStorage stateStorage = this.getOrCreateStateStorageForKeyedState(newStateMetaInfo);
            keyedState = new KeyedListStateImpl<K, E>(this, keyedStateDescriptor, stateStorage);
            this.keyedStates.put(stateName, keyedState);
        }
        return keyedState;
    }

    @Override
    public <K, MK, MV> KeyedMapState<K, MK, MV> createKeyedMapState(KeyedMapStateDescriptor<K, MK, MV> keyedStateDescriptor) throws Exception {
        String stateName = keyedStateDescriptor.getName();
        KeyedMapStateImpl<K, MK, MV> keyedState = (KeyedMapStateImpl<K, MK, MV>)this.keyedStates.get(stateName);
        if (keyedState == null) {
            RegisteredStateMetaInfo newStateMetaInfo = this.tryRegisterStateMetaInfo(keyedStateDescriptor);
            StateStorage stateStorage = this.getOrCreateStateStorageForKeyedState(newStateMetaInfo);
            keyedState = new KeyedMapStateImpl<K, MK, MV>(this, keyedStateDescriptor, stateStorage);
            this.keyedStates.put(stateName, keyedState);
        }
        return keyedState;
    }

    @Override
    public <K, MK, MV> KeyedSortedMapState<K, MK, MV> createKeyedSortedMapState(KeyedSortedMapStateDescriptor<K, MK, MV> keyedStateDescriptor) throws Exception {
        String stateName = keyedStateDescriptor.getName();
        KeyedSortedMapStateImpl<K, MK, MV> keyedState = (KeyedSortedMapStateImpl<K, MK, MV>)this.keyedStates.get(stateName);
        if (keyedState == null) {
            RegisteredStateMetaInfo newStateMetaInfo = this.tryRegisterStateMetaInfo(keyedStateDescriptor);
            StateStorage stateStorage = this.getOrCreateStateStorageForKeyedState(newStateMetaInfo);
            keyedState = new KeyedSortedMapStateImpl<K, MK, MV>(this, keyedStateDescriptor, stateStorage);
            this.keyedStates.put(stateName, keyedState);
        }
        return keyedState;
    }

    @Override
    public <K, N, V> SubKeyedValueState<K, N, V> createSubKeyedValueState(SubKeyedValueStateDescriptor<K, N, V> subKeyedStateDescriptor) throws Exception {
        String stateName = subKeyedStateDescriptor.getName();
        SubKeyedValueStateImpl subKeyedState = (SubKeyedValueStateImpl)this.subKeyedStates.get(stateName);
        if (subKeyedState == null) {
            RegisteredStateMetaInfo newStateMetaInfo = this.tryRegisterStateMetaInfo(subKeyedStateDescriptor);
            StateStorage stateStorage = this.getOrCreateStateStorageForSubKeyedState(newStateMetaInfo);
            subKeyedState = new SubKeyedValueStateImpl(this, subKeyedStateDescriptor, stateStorage);
            this.subKeyedStates.put(stateName, subKeyedState);
        }
        return subKeyedState;
    }

    @Override
    public <K, N, E> SubKeyedListState<K, N, E> createSubKeyedListState(SubKeyedListStateDescriptor<K, N, E> subKeyedStateDescriptor) throws Exception {
        String stateName = subKeyedStateDescriptor.getName();
        SubKeyedListStateImpl<K, N, E> subKeyedState = (SubKeyedListStateImpl<K, N, E>)this.subKeyedStates.get(stateName);
        if (subKeyedState == null) {
            RegisteredStateMetaInfo newStateMetaInfo = this.tryRegisterStateMetaInfo(subKeyedStateDescriptor);
            StateStorage stateStorage = this.getOrCreateStateStorageForSubKeyedState(newStateMetaInfo);
            subKeyedState = new SubKeyedListStateImpl<K, N, E>(this, subKeyedStateDescriptor, stateStorage);
            this.subKeyedStates.put(stateName, subKeyedState);
        }
        return subKeyedState;
    }

    @Override
    public <K, N, MK, MV> SubKeyedMapState<K, N, MK, MV> createSubKeyedMapState(SubKeyedMapStateDescriptor<K, N, MK, MV> subKeyedStateDescriptor) throws Exception {
        String stateName = subKeyedStateDescriptor.getName();
        SubKeyedMapStateImpl subKeyedState = (SubKeyedMapStateImpl)this.subKeyedStates.get(stateName);
        if (subKeyedState == null) {
            RegisteredStateMetaInfo newStateMetaInfo = this.tryRegisterStateMetaInfo(subKeyedStateDescriptor);
            StateStorage stateStorage = this.getOrCreateStateStorageForSubKeyedState(newStateMetaInfo);
            subKeyedState = new SubKeyedMapStateImpl(this, subKeyedStateDescriptor, stateStorage);
            this.subKeyedStates.put(stateName, subKeyedState);
        }
        return subKeyedState;
    }

    @Override
    public <K, N, MK, MV> SubKeyedSortedMapState<K, N, MK, MV> createSubKeyedSortedMapState(SubKeyedSortedMapStateDescriptor<K, N, MK, MV> subKeyedStateDescriptor) throws Exception {
        String stateName = subKeyedStateDescriptor.getName();
        SubKeyedSortedMapStateImpl<K, N, MK, MV> subKeyedState = (SubKeyedSortedMapStateImpl<K, N, MK, MV>)this.subKeyedStates.get(stateName);
        if (subKeyedState == null) {
            RegisteredStateMetaInfo newStateMetaInfo = this.tryRegisterStateMetaInfo(subKeyedStateDescriptor);
            StateStorage stateStorage = this.getOrCreateStateStorageForSubKeyedState(newStateMetaInfo);
            subKeyedState = new SubKeyedSortedMapStateImpl<K, N, MK, MV>(this, subKeyedStateDescriptor, stateStorage);
            this.subKeyedStates.put(stateName, subKeyedState);
        }
        return subKeyedState;
    }

    protected RegisteredStateMetaInfo tryRegisterStateMetaInfo(KeyedStateDescriptor stateDescriptor) throws StateMigrationException {
        Preconditions.checkNotNull((Object)stateDescriptor);
        String stateName = stateDescriptor.getName();
        RegisteredStateMetaInfo stateInfo = this.registeredStateMetaInfos.get(stateName);
        if (stateInfo != null) {
            StateMetaInfoSnapshot restoredStateMetaInfoSnapshot = this.restoredKvStateMetaInfos.get(stateName);
            Preconditions.checkState((restoredStateMetaInfoSnapshot != null ? 1 : 0) != 0, (Object)"Requested to check compatibility of a restored StateMetaInfoSnapshot, but its corresponding restored snapshot cannot be found.");
            stateInfo = RegisteredStateMetaInfo.resolveStateCompatibility(restoredStateMetaInfoSnapshot, stateDescriptor);
        } else {
            stateInfo = RegisteredStateMetaInfo.createKeyedStateMetaInfo(stateDescriptor.getStateType(), stateName, stateDescriptor.getKeySerializer(), stateDescriptor.getValueSerializer());
        }
        stateDescriptor.setKeySerializer(stateInfo.getKeySerializer());
        stateDescriptor.setValueSerializer(stateInfo.getValueSerializer());
        this.registeredStateMetaInfos.put(stateName, stateInfo);
        return stateInfo;
    }

    protected RegisteredStateMetaInfo tryRegisterStateMetaInfo(SubKeyedStateDescriptor stateDescriptor) throws StateMigrationException {
        Preconditions.checkNotNull((Object)stateDescriptor);
        String stateName = stateDescriptor.getName();
        RegisteredStateMetaInfo stateInfo = this.registeredStateMetaInfos.get(stateName);
        if (stateInfo != null) {
            StateMetaInfoSnapshot restoredStateMetaInfoSnapshot = this.restoredKvStateMetaInfos.get(stateName);
            Preconditions.checkState((restoredStateMetaInfoSnapshot != null ? 1 : 0) != 0, (Object)"Requested to check compatibility of a restored StateMetaInfoSnapshot, but its corresponding restored snapshot cannot be found.");
            stateInfo = RegisteredStateMetaInfo.resolveStateCompatibility(restoredStateMetaInfoSnapshot, stateDescriptor);
        } else {
            stateInfo = RegisteredStateMetaInfo.createSubKeyedStateMetaInfo(stateDescriptor.getStateType(), stateName, stateDescriptor.getKeySerializer(), stateDescriptor.getValueSerializer(), stateDescriptor.getNamespaceSerializer());
        }
        this.registeredStateMetaInfos.put(stateName, stateInfo);
        return stateInfo;
    }

    @Override
    public Map<String, StateStorage> getStateStorages() {
        return this.stateStorages;
    }

    public StreamCompressionDecorator getKeyGroupCompressionDecorator() {
        return this.keyGroupCompressionDecorator;
    }
}

