/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.flink.types.Pair;

public class GroupIterator
implements Iterator<Pair<byte[], byte[]>> {
    private final Queue<Iterator<Pair<byte[], byte[]>>> groupIterators = new LinkedList<Iterator<Pair<byte[], byte[]>>>();
    private volatile Iterator<Pair<byte[], byte[]>> headIterator;

    public GroupIterator(Collection<Iterator<Pair<byte[], byte[]>>> iteratorCollection) {
        for (Iterator<Pair<byte[], byte[]>> iterator : iteratorCollection) {
            if (!iterator.hasNext()) continue;
            this.groupIterators.add(iterator);
        }
        this.headIterator = this.groupIterators.poll();
    }

    @Override
    public boolean hasNext() {
        return !this.groupIterators.isEmpty() || this.headIterator != null && this.headIterator.hasNext();
    }

    @Override
    public Pair<byte[], byte[]> next() {
        if (!this.headIterator.hasNext() && !this.groupIterators.isEmpty()) {
            this.headIterator = this.groupIterators.poll();
        }
        return this.headIterator.next();
    }

    @Override
    public void remove() {
        this.headIterator.remove();
    }
}

