/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.IncrementalKeyedStateSnapshot;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.PlaceholderSegmentStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileSegmentStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalSegmentStateSnapshot
extends IncrementalKeyedStateSnapshot {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalSegmentStateSnapshot.class);
    private static final long serialVersionUID = 1L;
    private transient SharedStateRegistry sharedStateRegistry = null;

    public IncrementalSegmentStateSnapshot(KeyGroupRange keyGroupRange, long checkpointId, Map<StateHandleID, Tuple2<String, StreamStateHandle>> sharedState, Map<StateHandleID, StreamStateHandle> privateState, StreamStateHandle metaStateHandle) {
        super(keyGroupRange, checkpointId, sharedState, privateState, metaStateHandle);
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
        Preconditions.checkState((this.sharedStateRegistry != stateRegistry ? 1 : 0) != 0, (Object)"The state handle has already registered its shared states to the given registry.");
        this.sharedStateRegistry = (SharedStateRegistry)Preconditions.checkNotNull((Object)stateRegistry);
        LOG.trace("Registering IncrementalSegmentStateSnapshot for checkpoint {} from backend.", (Object)this.getCheckpointId());
        StreamStateHandle metaStateHandle = this.getMetaStateHandle();
        this.registerSegmentHandle(stateRegistry, metaStateHandle);
        for (Map.Entry<StateHandleID, Tuple2<String, StreamStateHandle>> entry : this.getSharedState().entrySet()) {
            StreamStateHandle stateHandle = (StreamStateHandle)entry.getValue().f1;
            if (stateHandle instanceof FileSegmentStateHandle) {
                this.registerSegmentHandle(stateRegistry, (StreamStateHandle)entry.getValue().f1);
                continue;
            }
            if (!(stateHandle instanceof PlaceholderSegmentStateHandle)) continue;
            PlaceholderSegmentStateHandle placeholderSegmentStateHandle = (PlaceholderSegmentStateHandle)stateHandle;
            String uniqueId = placeholderSegmentStateHandle.getFilePath().toString();
            SharedStateRegistryKey registryKey = this.createSharedStateRegistryKeyFromUniqueId(uniqueId);
            stateRegistry.registerReference(registryKey, placeholderSegmentStateHandle);
            entry.setValue((Tuple2<String, StreamStateHandle>)Tuple2.of((Object)uniqueId, (Object)placeholderSegmentStateHandle.toFileSegmentStateHandle()));
        }
        for (Map.Entry<StateHandleID, Object> entry : this.getPrivateState().entrySet()) {
            this.registerSegmentHandle(stateRegistry, (StreamStateHandle)entry.getValue());
        }
    }

    private void registerSegmentHandle(SharedStateRegistry stateRegistry, StreamStateHandle streamStateHandle) {
        Preconditions.checkState((boolean)(streamStateHandle instanceof FileSegmentStateHandle), (Object)"The state handle to register should be a FileSegmentStateHandle.");
        SharedStateRegistryKey registryKey = ((FileSegmentStateHandle)streamStateHandle).getRegistryKey();
        stateRegistry.registerReference(registryKey, streamStateHandle);
    }

    @Override
    public void discardState() {
        SharedStateRegistry registry = this.sharedStateRegistry;
        boolean isRegistered = registry != null;
        LOG.trace("Discarding IncrementalKeyedStateSnapshot (registered = {}) for checkpoint {} from backend.", (Object)isRegistered, (Object)this.getCheckpointId());
        if (isRegistered) {
            registry.unregisterReference(this.createSharedStateRegistryKeyFromSegment(this.getMetaStateHandle()));
            for (Map.Entry<StateHandleID, Tuple2<String, StreamStateHandle>> entry : this.getSharedState().entrySet()) {
                registry.unregisterReference(this.createSharedStateRegistryKeyFromUniqueId((String)entry.getValue().f0));
            }
            for (Map.Entry<StateHandleID, Object> entry : this.getPrivateState().entrySet()) {
                registry.unregisterReference(this.createSharedStateRegistryKeyFromSegment((StreamStateHandle)entry.getValue()));
            }
        }
    }

    public String toString() {
        return "IncrementalSegmentStateSnapshot{keyGroupRange=" + this.getKeyGroupRange() + ", checkpointId=" + this.getCheckpointId() + ", sharedState=" + this.getSharedState() + ", privateState=" + this.getPrivateState() + ", metaStateHandle=" + this.getMetaStateHandle() + ", registered=" + (this.sharedStateRegistry != null) + '}';
    }

    SharedStateRegistryKey createSharedStateRegistryKeyFromUniqueId(String uniqueId) {
        return new SharedStateRegistryKey(uniqueId);
    }

    private SharedStateRegistryKey createSharedStateRegistryKeyFromSegment(StreamStateHandle streamStateHandle) {
        Preconditions.checkState((boolean)(streamStateHandle instanceof FileSegmentStateHandle), (Object)"Incremental segment state snapshot only supports FileSegmentStateHandle.");
        return new SharedStateRegistryKey(((FileSegmentStateHandle)streamStateHandle).getFilePath().toString());
    }
}

